<?php
/**
 * Live Composer plugin integration
 *
 * -------------------------------------------------------------------
 *
 * DESCRIPTION:
 *
 * Live Composer is a backbone of our theme. We use all its features
 * to maximize customization and flexibility of our theme.
 *
 * In this file we extend some of the Live Composer aspects:
 * 	– Disable LC Templates for 'dslc_projects' content type
 *  	– Alter LiveComposer Default Modules Styling
 *   	– Custom shortcodes specially used to extend LC functionality
 *
 * @package    SEOWP WordPress Theme
 * @author     Vlad Mitkovsky <info@lumbermandesigns.com>
 * @copyright  2014 Lumberman Designs
 * @license    GNU GPL, Version 3
 * @link       http://themeforest.net/user/lumbermandesigns
 *
 * -------------------------------------------------------------------
 *
 * Send your ideas on code improvement or new hook requests using
 * contact form on http://themeforest.net/user/lumbermandesigns
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


function lbmn_deregister_lc_fontawesome() {
	if ( defined( 'DS_LIVE_COMPOSER_URL' ) && !DS_LIVE_COMPOSER_ACTIVE) {
		// Deregister Font-Awesome css added by LC
		wp_dequeue_style( 'dslc-font-awesome' );
	}
}
add_action( 'wp_enqueue_scripts', 'lbmn_deregister_lc_fontawesome', 100, 1 ); // dflt prrty is 20


// Check if Live Composer is active
if ( defined( 'DS_LIVE_COMPOSER_URL' ) ) {

	// Include Archive page template support
	require( get_template_directory() . '/inc/plugins-integration/livecomposer-archive.php' );

	// Include Custom Footer template support
	require( get_template_directory() . '/inc/plugins-integration/livecomposer-footer.php' );

	// define( 'DS_LIVE_COMPOSER_HF', true );

	// Include search support for Live Composer pages
	require( get_template_directory() . '/inc/plugins-integration/livecomposer-search.php' );


	/**
	 * ----------------------------------------------------------------------
	 * Make Live Composer to output custom CSS in the footer by default
	 */

	add_action( 'init', 'lbmn_output_lc_css_in_footer' );
	function lbmn_output_lc_css_in_footer() {
		$options = get_option( 'dslc_plugin_options' );
		$dynamic_css_location = $options['lc_css_position'];

		if ( ! $dynamic_css_location ) {
			$options['lc_css_position'] = 'body';
			update_option( 'dslc_plugin_options', $options );
		}
	}



	/**
	 * ----------------------------------------------------------------------
	 * Remove default templates from Templates > Load
	 * Add new templates
	 */
	add_action( 'init', 'remove_and_add_dslc_var_templates', 9 );
	function remove_and_add_dslc_var_templates() {
		global $dslc_var_templates;

		// $dslc_var_templates = array();
		// Remove default LC page templates
		if( !empty($dslc_var_templates) ) {

			unset($dslc_var_templates['dslc-blog-ex-1']);
			unset($dslc_var_templates['dslc-blog-ex-2']);
			unset($dslc_var_templates['dslc-blog-ex-3']);
			unset($dslc_var_templates['dslc-projects-ex-1']);
			unset($dslc_var_templates['dslc-projects-ex-2']);
			unset($dslc_var_templates['dslc-partners-ex-1']);
			unset($dslc_var_templates['dslc-products-ex-1']);
			unset($dslc_var_templates['dslc-products-ex-2']);
			unset($dslc_var_templates['dslc-staff-ex-1']);
			unset($dslc_var_templates['dslc-staff-ex-2']);

		}

		$dslc_var_templates['dslc-basic'] = array(
			'title' => __( 'Basic Page Template', 'dslc_string' ),
			'id' => 'dslc-basic',
			'code' => '[dslc_modules_section type="wrapped" columns_spacing="spacing" border_color="rgb(241, 241, 241)" border_width="1" border_style="solid" border="bottom " bg_color="" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="50" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] [dslc_modules_area last="yes" first="no" size="12"] [dslc_module]YTozOntzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6MTIxO3M6NzoicG9zdF9pZCI7czo0OiIxMjE4IjtzOjk6Im1vZHVsZV9pZCI7czoxMzoiRFNMQ19UUF9UaXRsZSI7fQ==[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] [dslc_modules_section type="wrapped" columns_spacing="spacing" border_color="" border_width="0" border_style="solid" border="top bottom" bg_color="" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="50" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] [dslc_modules_area last="yes" first="no" size="12"] [dslc_module]YTo3OntzOjE3OiJjc3NfbWFyZ2luX2JvdHRvbSI7czoyOiI0MCI7czoxNDoiY3NzX21haW5fY29sb3IiO3M6MTg6InJnYigxMjksIDEyOSwgMTI5KSI7czoxODoiY3NzX21haW5fZm9udF9zaXplIjtzOjI6IjIwIjtzOjIwOiJjc3NfbWFpbl9saW5lX2hlaWdodCI7czoyOiIzMCI7czoxODoibW9kdWxlX2luc3RhbmNlX2lkIjtzOjM6IjEyMiI7czo3OiJwb3N0X2lkIjtzOjQ6IjEyMTgiO3M6OToibW9kdWxlX2lkIjtzOjE2OiJEU0xDX1RleHRfU2ltcGxlIjt9[/dslc_module] [dslc_module]YTozOntzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO3M6MzoiMTIzIjtzOjc6InBvc3RfaWQiO3M6NDoiMTIxOCI7czo5OiJtb2R1bGVfaWQiO3M6MTY6IkRTTENfVGV4dF9TaW1wbGUiO30=[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] ',
			'section' => 'original'
		);

		$dslc_var_templates['dslc-about'] = array(
			'title' => __( 'About', 'dslc_string' ),
			'id' => 'dslc-about',
			'code' => '[dslc_modules_section type="wrapped" columns_spacing="spacing" border_color="" border_width="0" border_style="solid" border="top bottom" bg_color="rgb(45, 133, 196)" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="0" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="no" first="yes" size="8"] 
[dslc_module]YTo1OntzOjY6ImhlaWdodCI7czoyOiIxNSI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6MTg6Im1vZHVsZV9pbnN0YW5jZV9pZCI7aTo4NDU2O3M6NzoicG9zdF9pZCI7czo0OiIxMjY2IjtzOjk6Im1vZHVsZV9pZCI7czoxNDoiRFNMQ19TZXBhcmF0b3IiO30=[/dslc_module] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="4"] 
[dslc_module]YToxNTp7czo1OiJpbWFnZSI7czo0OiIxMDU3IjtzOjIwOiJjc3NfcGFkZGluZ192ZXJ0aWNhbCI7czoyOiIzNCI7czoxNjoiY3NzX2N0X2ZvbnRfc2l6ZSI7czoyOiIxMyI7czoxODoiY3NzX2N0X2ZvbnRfd2VpZ2h0IjtzOjM6IjQwMCI7czoxODoiY3NzX2N0X2ZvbnRfZmFtaWx5IjtzOjk6Ik9wZW4gU2FucyI7czo5OiJjc3NfcmVzX3QiO3M6NzoiZW5hYmxlZCI7czoyMzoiY3NzX3Jlc190X21hcmdpbl9ib3R0b20iO3M6MjoiMjAiO3M6MjY6ImNzc19yZXNfdF9wYWRkaW5nX3ZlcnRpY2FsIjtzOjI6IjEwIjtzOjI4OiJjc3NfcmVzX3RfcGFkZGluZ19ob3Jpem9udGFsIjtzOjI6IjMxIjtzOjk6ImNzc19yZXNfcCI7czo3OiJlbmFibGVkIjtzOjIzOiJjc3NfcmVzX3BfbWFyZ2luX2JvdHRvbSI7czoyOiIzMCI7czoyODoiY3NzX3Jlc19wX3BhZGRpbmdfaG9yaXpvbnRhbCI7czoxOiI0IjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO3M6NDoiODQ1OCI7czo3OiJwb3N0X2lkIjtzOjM6IjQzMCI7czo5OiJtb2R1bGVfaWQiO3M6MTA6IkRTTENfSW1hZ2UiO30=[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
[dslc_modules_section type="wrapped" columns_spacing="nospacing" border_color="" border_width="0" border_style="solid" border="top bottom" bg_color="rgb(248, 249, 250)" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="0" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
[dslc_modules_section type="wrapped" columns_spacing="spacing" border_color="rgb(244, 244, 244)" border_width="1" border_style="solid" border="bottom " bg_color="" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="0" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo5OntzOjY6ImhlaWdodCI7czoyOiIzMCI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6OToiY3NzX3Jlc190IjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc190X2hlaWdodCI7czoyOiIxNSI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czoxMjoicmVzX3BfaGVpZ2h0IjtzOjI6IjE1IjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6NjUzOTtzOjc6InBvc3RfaWQiO3M6NDoiMTI2MyI7czo5OiJtb2R1bGVfaWQiO3M6MTQ6IkRTTENfU2VwYXJhdG9yIjt9[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="no" first="yes" size="6"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="6"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo5OntzOjY6ImhlaWdodCI7czoyOiIzMCI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6OToiY3NzX3Jlc190IjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc190X2hlaWdodCI7czoyOiIxNSI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czoxMjoicmVzX3BfaGVpZ2h0IjtzOjI6IjE1IjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6NjU0MjtzOjc6InBvc3RfaWQiO3M6NDoiMTI2MyI7czo5OiJtb2R1bGVfaWQiO3M6MTQ6IkRTTENfU2VwYXJhdG9yIjt9[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
[dslc_modules_section type="wrapped" columns_spacing="nospacing" border_color="rgb(244, 244, 244)" border_width="1" border_style="solid" border="bottom " bg_color="" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="0" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YToxMTp7czoyMToiY3NzX21haW5fYm9yZGVyX2NvbG9yIjtzOjExOiJ0cmFuc3BhcmVudCI7czoxNjoiY3NzX2JvcmRlcl9jb2xvciI7czoyMjoicmdiYSgyNTUsIDI1NSwgMjU1LCAwKSI7czo2OiJoZWlnaHQiO3M6MjoiMzAiO3M6NToic3R5bGUiO3M6OToiaW52aXNpYmxlIjtzOjk6ImNzc19yZXNfdCI7czo3OiJlbmFibGVkIjtzOjEyOiJyZXNfdF9oZWlnaHQiO3M6MjoiMTUiO3M6OToiY3NzX3Jlc19wIjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc19wX2hlaWdodCI7czoyOiIxNSI7czoxODoibW9kdWxlX2luc3RhbmNlX2lkIjtpOjI5MzA7czo3OiJwb3N0X2lkIjtzOjQ6IjEyNjYiO3M6OToibW9kdWxlX2lkIjtzOjE0OiJEU0xDX1NlcGFyYXRvciI7fQ==[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="no" first="yes" size="2"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="no" first="no" size="2"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="no" first="no" size="2"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="no" first="no" size="2"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="no" first="no" size="2"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="2"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YToxMDp7czoxNjoiY3NzX2JvcmRlcl9jb2xvciI7czoxMToidHJhbnNwYXJlbnQiO3M6NjoiaGVpZ2h0IjtzOjI6IjMwIjtzOjU6InN0eWxlIjtzOjk6ImludmlzaWJsZSI7czo5OiJjc3NfcmVzX3QiO3M6NzoiZW5hYmxlZCI7czoxMjoicmVzX3RfaGVpZ2h0IjtzOjI6IjE1IjtzOjk6ImNzc19yZXNfcCI7czo3OiJlbmFibGVkIjtzOjEyOiJyZXNfcF9oZWlnaHQiO3M6MjoiMTUiO3M6MTg6Im1vZHVsZV9pbnN0YW5jZV9pZCI7aToyOTM3O3M6NzoicG9zdF9pZCI7czo0OiIxMjY2IjtzOjk6Im1vZHVsZV9pZCI7czoxNDoiRFNMQ19TZXBhcmF0b3IiO30=[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
[dslc_modules_section type="wrapped" columns_spacing="spacing" border_color="" border_width="0" border_style="solid" border="top bottom" bg_color="rgb(59, 67, 74)" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="0" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo5OntzOjY6ImhlaWdodCI7czoyOiIzMCI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6OToiY3NzX3Jlc190IjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc190X2hlaWdodCI7czoyOiIxNSI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czoxMjoicmVzX3BfaGVpZ2h0IjtzOjI6IjE1IjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6NTM4MTtzOjc6InBvc3RfaWQiO3M6NDoiMTI2MyI7czo5OiJtb2R1bGVfaWQiO3M6MTQ6IkRTTENfU2VwYXJhdG9yIjt9[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]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[/dslc_module] 
[dslc_module]YTozOntzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6NTM4MztzOjc6InBvc3RfaWQiO3M6MzoiNDMwIjtzOjk6Im1vZHVsZV9pZCI7czoxNToiRFNMQ19UUF9Db250ZW50Ijt9[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
[dslc_modules_section type="wrapped" columns_spacing="spacing" border_color="" border_width="0" border_style="solid" border="top bottom" bg_color="rgb(55, 62, 69)" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="0" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo5OntzOjY6ImhlaWdodCI7czoyOiIzMCI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6OToiY3NzX3Jlc190IjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc190X2hlaWdodCI7czoyOiIxNSI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czoxMjoicmVzX3BfaGVpZ2h0IjtzOjI6IjE1IjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6ODU5MTtzOjc6InBvc3RfaWQiO3M6NDoiMTI2MyI7czo5OiJtb2R1bGVfaWQiO3M6MTQ6IkRTTENfU2VwYXJhdG9yIjt9[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="no" first="yes" size="3"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="no" first="no" size="3"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="no" first="no" size="3"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="3"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo5OntzOjY6ImhlaWdodCI7czoyOiIzMCI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6OToiY3NzX3Jlc190IjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc190X2hlaWdodCI7czoyOiIxNSI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czoxMjoicmVzX3BfaGVpZ2h0IjtzOjE6IjIiO3M6MTg6Im1vZHVsZV9pbnN0YW5jZV9pZCI7aTo4NTk2O3M6NzoicG9zdF9pZCI7czo0OiIxMjYzIjtzOjk6Im1vZHVsZV9pZCI7czoxNDoiRFNMQ19TZXBhcmF0b3IiO30=[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
[dslc_modules_section type="wrapped" columns_spacing="nospacing" border_color="" border_width="0" border_style="solid" border="top bottom" bg_color="rgb(89, 172, 231)" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="0" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo5OntzOjY6ImhlaWdodCI7czoyOiIzMCI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6OToiY3NzX3Jlc190IjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc190X2hlaWdodCI7czoyOiIxNSI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czoxMjoicmVzX3BfaGVpZ2h0IjtzOjI6IjE1IjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6NTQyOTtzOjc6InBvc3RfaWQiO3M6NDoiMTI2MyI7czo5OiJtb2R1bGVfaWQiO3M6MTQ6IkRTTENfU2VwYXJhdG9yIjt9[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo5OntzOjY6ImhlaWdodCI7czoyOiIzMCI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6OToiY3NzX3Jlc190IjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc190X2hlaWdodCI7czoyOiIxNSI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czoxMjoicmVzX3BfaGVpZ2h0IjtzOjI6IjE1IjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6NTQzMTtzOjc6InBvc3RfaWQiO3M6NDoiMTI2MyI7czo5OiJtb2R1bGVfaWQiO3M6MTQ6IkRTTENfU2VwYXJhdG9yIjt9[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
[dslc_modules_section type="wrapped" columns_spacing="nospacing" border_color="rgb(239, 237, 237)" border_width="1" border_style="solid" border="" bg_color="" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="0" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo5OntzOjY6ImhlaWdodCI7czoyOiIzMCI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6OToiY3NzX3Jlc190IjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc190X2hlaWdodCI7czoyOiIxNSI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czoxMjoicmVzX3BfaGVpZ2h0IjtzOjI6IjEwIjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6NTQ1NDtzOjc6InBvc3RfaWQiO3M6MzoiNDMwIjtzOjk6Im1vZHVsZV9pZCI7czoxNDoiRFNMQ19TZXBhcmF0b3IiO30=[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="no" first="yes" size="1"] 
[dslc_module]YTo2OntzOjU6InN0eWxlIjtzOjk6ImludmlzaWJsZSI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czoxMjoicmVzX3BfaGVpZ2h0IjtzOjE6IjEiO3M6MTg6Im1vZHVsZV9pbnN0YW5jZV9pZCI7aTo1NDU1O3M6NzoicG9zdF9pZCI7czo0OiIxMjY2IjtzOjk6Im1vZHVsZV9pZCI7czoxNDoiRFNMQ19TZXBhcmF0b3IiO30=[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="no" first="no" size="10"] 
[dslc_module]YTo2Njp7czo3OiJjb250ZW50IjtzOjE5NDoiPGgyPlBhc3Npb25hdGUgQWJvdXQgT3VyIENsaWVudHM8L2gyPjxwPk91ciBkaWdpdGFsIG1hcmtldGluZyB3b3JrIHNwZWFrcyBmb3IgaXRzZWxmLiBXZSBkZWxpdmVyIGEgcGVyc29uYWwsIHBhc3Npb25hdGUgJiB0YWlsb3JlZCBzZXJ2aWNlIHRvIGVhY2ggYW5kIGV2ZXJ5IG9uZSBvZiBvdXIgY2xpZW50cywgYmlnIG9yIHNtYWxsLjwvcD4iO3M6MjE6ImNzc19tYWluX2JvcmRlcl9jb2xvciI7czoxODoicmdiKDIxNiwgMjE2LCAyMTYpIjtzOjIwOiJjc3NfbWFpbl9ib3JkZXJfdHJibCI7czo3OiJib3R0b20gIjtzOjE3OiJjc3NfbWFyZ2luX2JvdHRvbSI7czoyOiIxNSI7czoyNzoiY3NzX21haW5fcGFkZGluZ19ob3Jpem9udGFsIjtzOjI6IjMzIjtzOjE0OiJjc3NfbWFpbl9jb2xvciI7czoxODoicmdiKDE1OCwgMTU4LCAxNTgpIjtzOjE4OiJjc3NfbWFpbl9mb250X3NpemUiO3M6MjoiMjEiO3M6MjA6ImNzc19tYWluX2ZvbnRfd2VpZ2h0IjtzOjM6IjMwMCI7czoyMDoiY3NzX21haW5fbGluZV9oZWlnaHQiO3M6MjoiMzAiO3M6MjI6ImNzc19tYWluX21hcmdpbl9ib3R0b20iO3M6MToiMCI7czoxOToiY3NzX21haW5fdGV4dF9hbGlnbiI7czo2OiJjZW50ZXIiO3M6MTY6ImNzc19oMV9mb250X3NpemUiO3M6MjoiNjYiO3M6MTg6ImNzc19oMV9mb250X3dlaWdodCI7czozOiIyMDAiO3M6MTg6ImNzc19oMV9mb250X2ZhbWlseSI7czo2OiJSb2JvdG8iO3M6MTg6ImNzc19oMV9saW5lX2hlaWdodCI7czoyOiI3MCI7czoyMDoiY3NzX2gxX21hcmdpbl9ib3R0b20iO3M6MjoiMzAiO3M6MTI6ImNzc19oMl9jb2xvciI7czoxNToicmdiKDE1LCAxNiwgMTYpIjtzOjE2OiJjc3NfaDJfZm9udF9zaXplIjtzOjI6IjUwIjtzOjE4OiJjc3NfaDJfZm9udF93ZWlnaHQiO3M6MzoiMjAwIjtzOjE4OiJjc3NfaDJfbGluZV9oZWlnaHQiO3M6MjoiNTUiO3M6MjA6ImNzc19oMl9tYXJnaW5fYm90dG9tIjtzOjI6IjI0IjtzOjE3OiJjc3NfaDJfdGV4dF9hbGlnbiI7czo2OiJjZW50ZXIiO3M6MTI6ImNzc19oM19jb2xvciI7czoxNToicmdiKDI3LCAyOCwgMjkpIjtzOjE2OiJjc3NfaDNfZm9udF9zaXplIjtzOjI6IjQyIjtzOjE4OiJjc3NfaDNfZm9udF93ZWlnaHQiO3M6MzoiMjAwIjtzOjE4OiJjc3NfaDNfZm9udF9mYW1pbHkiO3M6NjoiUm9ib3RvIjtzOjE4OiJjc3NfaDNfbGluZV9oZWlnaHQiO3M6MjoiNDgiO3M6MjA6ImNzc19oM19tYXJnaW5fYm90dG9tIjtzOjI6IjI1IjtzOjE2OiJjc3NfaDRfZm9udF9zaXplIjtzOjI6IjMwIjtzOjE4OiJjc3NfaDRfZm9udF93ZWlnaHQiO3M6MzoiMzAwIjtzOjE4OiJjc3NfaDRfZm9udF9mYW1pbHkiO3M6NjoiUm9ib3RvIjtzOjE4OiJjc3NfaDRfbGluZV9oZWlnaHQiO3M6MjoiMzgiO3M6MjA6ImNzc19oNF9tYXJnaW5fYm90dG9tIjtzOjI6IjIwIjtzOjE2OiJjc3NfaDVfZm9udF9zaXplIjtzOjI6IjI0IjtzOjE4OiJjc3NfaDVfZm9udF93ZWlnaHQiO3M6MzoiMzAwIjtzOjE4OiJjc3NfaDVfZm9udF9mYW1pbHkiO3M6NjoiUm9ib3RvIjtzOjE4OiJjc3NfaDVfbGluZV9oZWlnaHQiO3M6MjoiMzMiO3M6MjA6ImNzc19oNV9tYXJnaW5fYm90dG9tIjtzOjI6IjIwIjtzOjE2OiJjc3NfaDZfZm9udF9zaXplIjtzOjI6IjIxIjtzOjE4OiJjc3NfaDZfZm9udF93ZWlnaHQiO3M6MzoiNDAwIjtzOjE4OiJjc3NfaDZfZm9udF9mYW1pbHkiO3M6NjoiUm9ib3RvIjtzOjE4OiJjc3NfaDZfbGluZV9oZWlnaHQiO3M6MjoiMjkiO3M6MjA6ImNzc19oNl9tYXJnaW5fYm90dG9tIjtzOjI6IjIwIjtzOjk6ImNzc19yZXNfdCI7czo3OiJlbmFibGVkIjtzOjIzOiJjc3NfcmVzX3RfbWFyZ2luX2JvdHRvbSI7czoyOiIxMCI7czoyNDoiY3NzX3Jlc190X21haW5fZm9udF9zaXplIjtzOjI6IjE2IjtzOjI2OiJjc3NfcmVzX3RfbWFpbl9saW5lX2hlaWdodCI7czoyOiIyNiI7czoyMjoiY3NzX3Jlc190X2gyX2ZvbnRfc2l6ZSI7czoyOiI0MCI7czoyNDoiY3NzX3Jlc190X2gyX2xpbmVfaGVpZ2h0IjtzOjI6IjQ2IjtzOjI2OiJjc3NfcmVzX3RfaDJfbWFyZ2luX2JvdHRvbSI7czoyOiIxMiI7czoyMjoiY3NzX3Jlc190X2gzX2ZvbnRfc2l6ZSI7czoyOiIyNCI7czoyNDoiY3NzX3Jlc190X2gzX2xpbmVfaGVpZ2h0IjtzOjI6IjI2IjtzOjI2OiJjc3NfcmVzX3RfaDNfbWFyZ2luX2JvdHRvbSI7czoyOiIzMCI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czoyNDoiY3NzX3Jlc19waF9tYXJnaW5fYm90dG9tIjtzOjI6IjEwIjtzOjI1OiJjc3NfcmVzX3BoX21haW5fZm9udF9zaXplIjtzOjI6IjE1IjtzOjI3OiJjc3NfcmVzX3BoX21haW5fbGluZV9oZWlnaHQiO3M6MjoiMjEiO3M6MjM6ImNzc19yZXNfcGhfaDJfZm9udF9zaXplIjtzOjI6IjIxIjtzOjI1OiJjc3NfcmVzX3BoX2gyX2xpbmVfaGVpZ2h0IjtzOjI6IjMyIjtzOjI2OiJjc3NfcmVzX3BfaDJfbWFyZ2luX2JvdHRvbSI7czoxOiI3IjtzOjIzOiJjc3NfcmVzX3BoX2gzX2ZvbnRfc2l6ZSI7czoyOiIxOCI7czoyNToiY3NzX3Jlc19waF9oM19saW5lX2hlaWdodCI7czoyOiIyNCI7czoyNjoiY3NzX3Jlc19wX2gzX21hcmdpbl9ib3R0b20iO3M6MjoiMjAiO3M6MTg6Im1vZHVsZV9pbnN0YW5jZV9pZCI7aTo1NDU2O3M6NzoicG9zdF9pZCI7czo0OiIxMjYzIjtzOjk6Im1vZHVsZV9pZCI7czoxNjoiRFNMQ19UZXh0X1NpbXBsZSI7fQ==[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="no" first="yes" size="12"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="no" first="yes" size="12"] 
[dslc_module]YTo5OntzOjY6ImhlaWdodCI7czoyOiIzMCI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6OToiY3NzX3Jlc190IjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc190X2hlaWdodCI7czoxOiI4IjtzOjk6ImNzc19yZXNfcCI7czo3OiJlbmFibGVkIjtzOjEyOiJyZXNfcF9oZWlnaHQiO3M6MToiMiI7czoxODoibW9kdWxlX2luc3RhbmNlX2lkIjtpOjU0NTg7czo3OiJwb3N0X2lkIjtzOjQ6IjEyNjYiO3M6OToibW9kdWxlX2lkIjtzOjE0OiJEU0xDX1NlcGFyYXRvciI7fQ==[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
[dslc_modules_section type="wrapped" columns_spacing="spacing" border_color="rgb(244, 244, 244)" border_width="1" border_style="solid" border="top " bg_color="" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="0" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo5OntzOjY6ImhlaWdodCI7czoyOiIzMCI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6OToiY3NzX3Jlc190IjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc190X2hlaWdodCI7czoyOiIxNSI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czoxMjoicmVzX3BfaGVpZ2h0IjtzOjI6IjE1IjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6NTQ3MDtzOjc6InBvc3RfaWQiO3M6NDoiMTI2MyI7czo5OiJtb2R1bGVfaWQiO3M6MTQ6IkRTTENfU2VwYXJhdG9yIjt9[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
[dslc_modules_section type="wrapped" columns_spacing="spacing" border_color="" border_width="0" border_style="solid" border="top bottom" bg_color="" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="0" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="no" first="yes" size="5"] 
[dslc_module]YTo0OntzOjU6InN0eWxlIjtzOjk6ImludmlzaWJsZSI7czoxODoibW9kdWxlX2luc3RhbmNlX2lkIjtpOjU0ODc7czo3OiJwb3N0X2lkIjtzOjM6IjQzMCI7czo5OiJtb2R1bGVfaWQiO3M6MTQ6IkRTTENfU2VwYXJhdG9yIjt9[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="no" first="no" size="2"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
[dslc_modules_section type="wrapped" columns_spacing="nospacing" border_color="" border_width="0" border_style="solid" border="top bottom" bg_color="" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="0" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="no" first="yes" size="6"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="6"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
[dslc_modules_section type="wrapped" columns_spacing="spacing" border_color="" border_width="0" border_style="solid" border="top bottom" bg_color="" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="0" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="no" first="yes" size="3"] 
[dslc_module]YTo0OntzOjU6InN0eWxlIjtzOjk6ImludmlzaWJsZSI7czoxODoibW9kdWxlX2luc3RhbmNlX2lkIjtpOjU0OTk7czo3OiJwb3N0X2lkIjtzOjM6IjQzMCI7czo5OiJtb2R1bGVfaWQiO3M6MTQ6IkRTTENfU2VwYXJhdG9yIjt9[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="no" first="no" size="6"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
[dslc_modules_section type="wrapped" columns_spacing="nospacing" border_color="" border_width="0" border_style="solid" border="top bottom" bg_color="" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="0" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="no" first="yes" size="6"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="6"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
[dslc_modules_section type="wrapped" columns_spacing="spacing" border_color="" border_width="0" border_style="solid" border="top bottom" bg_color="" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="0" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="no" first="yes" size="3"] 
[dslc_module]YTo0OntzOjU6InN0eWxlIjtzOjk6ImludmlzaWJsZSI7czoxODoibW9kdWxlX2luc3RhbmNlX2lkIjtpOjU1MTE7czo3OiJwb3N0X2lkIjtzOjM6IjQzMCI7czo5OiJtb2R1bGVfaWQiO3M6MTQ6IkRTTENfU2VwYXJhdG9yIjt9[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="no" first="no" size="6"] 
[dslc_module]YTo3ODp7czo4OiJlbGVtZW50cyI7czoxOToiaWNvbiB0aXRsZSBjb250ZW50ICI7czoxMDoidGV4dF9hbGlnbiI7czo2OiJjZW50ZXIiO3M6MTY6ImNzc19ib3JkZXJfY29sb3IiO3M6MTg6InJnYigyMzIsIDIzNCwgMjM2KSI7czoxNjoiY3NzX2JvcmRlcl93aWR0aCI7czoxOiIxIjtzOjE1OiJjc3NfYm9yZGVyX3RyYmwiO3M6MjI6InRvcCByaWdodCBib3R0b20gbGVmdCAiO3M6MTc6ImNzc19ib3JkZXJfcmFkaXVzIjtzOjE6IjMiO3M6MTc6ImNzc19tYXJnaW5fYm90dG9tIjtzOjE6IjAiO3M6MjI6ImNzc19wYWRkaW5nX2hvcml6b250YWwiO3M6MjoiNjAiO3M6MTc6ImNzc19pY29uX2JnX2NvbG9yIjtzOjE4OiJyZ2IoMjU1LCAyNTUsIDI1NSkiO3M6MjE6ImNzc19pY29uX2JvcmRlcl9jb2xvciI7czoxODoicmdiKDIzMiwgMjM0LCAyMzYpIjtzOjIyOiJjc3NfaWNvbl9ib3JkZXJfcmFkaXVzIjtzOjM6IjEwMCI7czoxNDoiY3NzX2ljb25fY29sb3IiO3M6MTc6InJnYigxNTgsIDE5MywgNDApIjtzOjc6Imljb25faWQiO3M6MTA6ImV4dC1tb2JpbGUiO3M6MTk6ImNzc19pY29uX21hcmdpbl90b3AiO3M6MzoiLTYzIjtzOjIxOiJjc3NfaWNvbl9tYXJnaW5fcmlnaHQiO3M6MToiMCI7czoxMzoiaWNvbl9wb3NpdGlvbiI7czo1OiJhYm92ZSI7czoyMjoiY3NzX2ljb25fd3JhcHBlcl93aWR0aCI7czozOiIxMjAiO3M6MTQ6ImNzc19pY29uX3dpZHRoIjtzOjI6IjUyIjtzOjE1OiJjc3NfdGl0bGVfY29sb3IiO3M6MTg6InJnYigxODYsIDE4NiwgMTg2KSI7czoxOToiY3NzX3RpdGxlX2ZvbnRfc2l6ZSI7czoyOiIxOSI7czoyMToiY3NzX3RpdGxlX2xpbmVfaGVpZ2h0IjtzOjI6IjIwIjtzOjE2OiJjc3NfdGl0bGVfbWFyZ2luIjtzOjI6IjI2IjtzOjE3OiJjc3NfY29udGVudF9jb2xvciI7czoxNToicmdiKDYxLCA2MSwgNjEpIjtzOjIxOiJjc3NfY29udGVudF9mb250X3NpemUiO3M6MjoiMjAiO3M6MjM6ImNzc19jb250ZW50X2ZvbnRfd2VpZ2h0IjtzOjM6IjMwMCI7czoyMzoiY3NzX2NvbnRlbnRfbGluZV9oZWlnaHQiO3M6MjoiMzAiO3M6MTg6ImNzc19jb250ZW50X21hcmdpbiI7czoyOiI3MCI7czoxOToiY3NzX2J1dHRvbl9iZ19jb2xvciI7czo3OiIjNTg5MGU1IjtzOjI1OiJjc3NfYnV0dG9uX2JnX2NvbG9yX2hvdmVyIjtzOjc6IiMzZTczYzIiO3M6MjM6ImNzc19idXR0b25fYm9yZGVyX3dpZHRoIjtzOjE6IjAiO3M6MjM6ImNzc19idXR0b25fYm9yZGVyX2NvbG9yIjtzOjc6IiNkOGQ4ZDgiO3M6Mjk6ImNzc19idXR0b25fYm9yZGVyX2NvbG9yX2hvdmVyIjtzOjA6IiI7czoxNjoiY3NzX2J1dHRvbl9jb2xvciI7czo3OiIjZmZmZmZmIjtzOjIwOiJjc3NfYnV0dG9uX2ZvbnRfc2l6ZSI7czoyOiIxMSI7czoyMjoiY3NzX2J1dHRvbl9mb250X3dlaWdodCI7czozOiI4MDAiO3M6MjI6ImNzc19idXR0b25fZm9udF9mYW1pbHkiO3M6OToiT3BlbiBTYW5zIjtzOjIxOiJjc3NfYnV0dG9uX21hcmdpbl90b3AiO3M6MToiMCI7czoyMzoiY3NzX2J1dHRvbl9tYXJnaW5fcmlnaHQiO3M6MToiMCI7czoxNDoiYnV0dG9uX2ljb25faWQiO3M6MzoiY29nIjtzOjIxOiJjc3NfYnV0dG9uX2ljb25fY29sb3IiO3M6NzoiI2IwYzhlYiI7czo1OiJ0aXRsZSI7czoxMDoiSnVuZSwgMjAxMyI7czo3OiJjb250ZW50IjtzOjk5OiI8cD5BZnRlciBmZXcgbW9udGhzIG9mIGhhcmQgd29yayB3ZSBwdWJsaXNoZWQgb3VyIGZpcnN0IGlPUyBhcHAgdGhhdCBxdWlja2x5IGdldCB0byB0aGUgdG9wIDUwITwvcD4iO3M6MTI6ImJ1dHRvbl90aXRsZSI7czoxMzoiQ0xJQ0sgVE8gRURJVCI7czo5OiJjc3NfcmVzX3QiO3M6NzoiZW5hYmxlZCI7czoyMzoiY3NzX3Jlc190X21hcmdpbl9ib3R0b20iO3M6MToiMCI7czoyODoiY3NzX3Jlc190X3BhZGRpbmdfaG9yaXpvbnRhbCI7czoyOiIxMyI7czoyNToiY3NzX3Jlc190X2ljb25fbWFyZ2luX3RvcCI7czozOiItNTUiO3M6Mjc6ImNzc19yZXNfdF9pY29uX21hcmdpbl9yaWdodCI7czoxOiIwIjtzOjI4OiJjc3NfcmVzX3RfaWNvbl93cmFwcGVyX3dpZHRoIjtzOjM6IjExMCI7czoyMDoiY3NzX3Jlc190X2ljb25fd2lkdGgiO3M6MjoiNDciO3M6MjU6ImNzc19yZXNfdF90aXRsZV9mb250X3NpemUiO3M6MjoiMTciO3M6Mjc6ImNzc19yZXNfdF90aXRsZV9saW5lX2hlaWdodCI7czoyOiIxNyI7czoyMjoiY3NzX3Jlc190X3RpdGxlX21hcmdpbiI7czoyOiIyMSI7czoyNzoiY3NzX3Jlc190X2NvbnRlbnRfZm9udF9zaXplIjtzOjI6IjE4IjtzOjI5OiJjc3NfcmVzX3RfY29udGVudF9saW5lX2hlaWdodCI7czoyOiIyMyI7czoyNDoiY3NzX3Jlc190X2NvbnRlbnRfbWFyZ2luIjtzOjI6IjQwIjtzOjI2OiJjc3NfcmVzX3RfYnV0dG9uX2ZvbnRfc2l6ZSI7czoyOiIxMSI7czozMzoiY3NzX3Jlc190X2J1dHRvbl9wYWRkaW5nX3ZlcnRpY2FsIjtzOjI6IjEzIjtzOjM1OiJjc3NfcmVzX3RfYnV0dG9uX3BhZGRpbmdfaG9yaXpvbnRhbCI7czoyOiIxNiI7czoyODoiY3NzX3Jlc190X2J1dHRvbl9pY29uX21hcmdpbiI7czoxOiI1IjtzOjk6ImNzc19yZXNfcCI7czo3OiJlbmFibGVkIjtzOjIzOiJjc3NfcmVzX3BfbWFyZ2luX2JvdHRvbSI7czoyOiI1MSI7czoyNToiY3NzX3Jlc19wX2ljb25fbWFyZ2luX3RvcCI7czozOiItNTAiO3M6Mjc6ImNzc19yZXNfcF9pY29uX21hcmdpbl9yaWdodCI7czoxOiIwIjtzOjI4OiJjc3NfcmVzX3BfaWNvbl93cmFwcGVyX3dpZHRoIjtzOjM6IjEwMCI7czoyMDoiY3NzX3Jlc19wX2ljb25fd2lkdGgiO3M6MjoiNDIiO3M6MjU6ImNzc19yZXNfcF90aXRsZV9mb250X3NpemUiO3M6MjoiMTYiO3M6Mjc6ImNzc19yZXNfcF90aXRsZV9saW5lX2hlaWdodCI7czoyOiIxNyI7czoyMjoiY3NzX3Jlc19wX3RpdGxlX21hcmdpbiI7czoyOiIyMSI7czoyNzoiY3NzX3Jlc19wX2NvbnRlbnRfZm9udF9zaXplIjtzOjI6IjE3IjtzOjI0OiJjc3NfcmVzX3BfY29udGVudF9tYXJnaW4iO3M6MjoiNDAiO3M6MjY6ImNzc19yZXNfcF9idXR0b25fZm9udF9zaXplIjtzOjI6IjExIjtzOjMzOiJjc3NfcmVzX3BfYnV0dG9uX3BhZGRpbmdfdmVydGljYWwiO3M6MjoiMTMiO3M6MzU6ImNzc19yZXNfcF9idXR0b25fcGFkZGluZ19ob3Jpem9udGFsIjtzOjI6IjE2IjtzOjI4OiJjc3NfcmVzX3BfYnV0dG9uX2ljb25fbWFyZ2luIjtzOjE6IjUiO3M6MTg6Im1vZHVsZV9pbnN0YW5jZV9pZCI7aTo1NTEyO3M6NzoicG9zdF9pZCI7czo0OiIxMjYzIjtzOjk6Im1vZHVsZV9pZCI7czoxMzoiRFNMQ19JbmZvX0JveCI7fQ==[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
[dslc_modules_section type="wrapped" columns_spacing="nospacing" border_color="" border_width="0" border_style="solid" border="top bottom" bg_color="" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="0" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="no" first="yes" size="6"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="6"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
[dslc_modules_section type="wrapped" columns_spacing="spacing" border_color="" border_width="0" border_style="solid" border="top bottom" bg_color="" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="0" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="no" first="yes" size="3"] [/dslc_modules_area] 
[dslc_modules_area last="no" first="no" size="6"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
[dslc_modules_section type="wrapped" columns_spacing="nospacing" border_color="" border_width="0" border_style="solid" border="top bottom" bg_color="" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="0" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="no" first="yes" size="6"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="6"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
[dslc_modules_section type="wrapped" columns_spacing="spacing" border_color="" border_width="0" border_style="solid" border="top bottom" bg_color="" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="0" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="no" first="yes" size="5"] 
[dslc_module]YTo0OntzOjU6InN0eWxlIjtzOjk6ImludmlzaWJsZSI7czoxODoibW9kdWxlX2luc3RhbmNlX2lkIjtpOjU1NTg7czo3OiJwb3N0X2lkIjtzOjM6IjQzMCI7czo5OiJtb2R1bGVfaWQiO3M6MTQ6IkRTTENfU2VwYXJhdG9yIjt9[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="no" first="no" size="2"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
[dslc_modules_section type="wrapped" columns_spacing="nospacing" border_color="" border_width="0" border_style="solid" border="top bottom" bg_color="" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="0" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="no" first="yes" size="6"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="6"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
[dslc_modules_section type="wrapped" columns_spacing="spacing" border_color="" border_width="0" border_style="solid" border="top bottom" bg_color="" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="0" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="no" first="yes" size="3"] [/dslc_modules_area] 
[dslc_modules_area last="no" first="no" size="6"] 
[dslc_module]YTo3ODp7czo4OiJlbGVtZW50cyI7czoxOToiaWNvbiB0aXRsZSBjb250ZW50ICI7czoxMDoidGV4dF9hbGlnbiI7czo2OiJjZW50ZXIiO3M6MTY6ImNzc19ib3JkZXJfY29sb3IiO3M6MTg6InJnYigyMzIsIDIzNCwgMjM2KSI7czoxNjoiY3NzX2JvcmRlcl93aWR0aCI7czoxOiIxIjtzOjE1OiJjc3NfYm9yZGVyX3RyYmwiO3M6MjI6InRvcCByaWdodCBib3R0b20gbGVmdCAiO3M6MTc6ImNzc19ib3JkZXJfcmFkaXVzIjtzOjE6IjMiO3M6MTc6ImNzc19tYXJnaW5fYm90dG9tIjtzOjE6IjAiO3M6MjI6ImNzc19wYWRkaW5nX2hvcml6b250YWwiO3M6MjoiNjAiO3M6MTc6ImNzc19pY29uX2JnX2NvbG9yIjtzOjE4OiJyZ2IoMjU1LCAyNTUsIDI1NSkiO3M6MjE6ImNzc19pY29uX2JvcmRlcl9jb2xvciI7czoxODoicmdiKDIzMiwgMjM0LCAyMzYpIjtzOjIyOiJjc3NfaWNvbl9ib3JkZXJfcmFkaXVzIjtzOjM6IjEwMCI7czoxNDoiY3NzX2ljb25fY29sb3IiO3M6MTc6InJnYigxNTgsIDE5MywgNDApIjtzOjc6Imljb25faWQiO3M6MTM6ImV4dC1icmllZmNhc2UiO3M6MTk6ImNzc19pY29uX21hcmdpbl90b3AiO3M6MzoiLTYzIjtzOjIxOiJjc3NfaWNvbl9tYXJnaW5fcmlnaHQiO3M6MToiMCI7czoxMzoiaWNvbl9wb3NpdGlvbiI7czo1OiJhYm92ZSI7czoyMjoiY3NzX2ljb25fd3JhcHBlcl93aWR0aCI7czozOiIxMjAiO3M6MTQ6ImNzc19pY29uX3dpZHRoIjtzOjI6IjUyIjtzOjE1OiJjc3NfdGl0bGVfY29sb3IiO3M6MTg6InJnYigxODYsIDE4NiwgMTg2KSI7czoxOToiY3NzX3RpdGxlX2ZvbnRfc2l6ZSI7czoyOiIxOSI7czoyMToiY3NzX3RpdGxlX2xpbmVfaGVpZ2h0IjtzOjI6IjIwIjtzOjE2OiJjc3NfdGl0bGVfbWFyZ2luIjtzOjI6IjI2IjtzOjE3OiJjc3NfY29udGVudF9jb2xvciI7czoxNToicmdiKDYxLCA2MSwgNjEpIjtzOjIxOiJjc3NfY29udGVudF9mb250X3NpemUiO3M6MjoiMjAiO3M6MjM6ImNzc19jb250ZW50X2ZvbnRfd2VpZ2h0IjtzOjM6IjMwMCI7czoyMzoiY3NzX2NvbnRlbnRfbGluZV9oZWlnaHQiO3M6MjoiMzAiO3M6MTg6ImNzc19jb250ZW50X21hcmdpbiI7czoyOiI3MCI7czoxOToiY3NzX2J1dHRvbl9iZ19jb2xvciI7czo3OiIjNTg5MGU1IjtzOjI1OiJjc3NfYnV0dG9uX2JnX2NvbG9yX2hvdmVyIjtzOjc6IiMzZTczYzIiO3M6MjM6ImNzc19idXR0b25fYm9yZGVyX3dpZHRoIjtzOjE6IjAiO3M6MjM6ImNzc19idXR0b25fYm9yZGVyX2NvbG9yIjtzOjc6IiNkOGQ4ZDgiO3M6Mjk6ImNzc19idXR0b25fYm9yZGVyX2NvbG9yX2hvdmVyIjtzOjA6IiI7czoxNjoiY3NzX2J1dHRvbl9jb2xvciI7czo3OiIjZmZmZmZmIjtzOjIwOiJjc3NfYnV0dG9uX2ZvbnRfc2l6ZSI7czoyOiIxMSI7czoyMjoiY3NzX2J1dHRvbl9mb250X3dlaWdodCI7czozOiI4MDAiO3M6MjI6ImNzc19idXR0b25fZm9udF9mYW1pbHkiO3M6OToiT3BlbiBTYW5zIjtzOjIxOiJjc3NfYnV0dG9uX21hcmdpbl90b3AiO3M6MToiMCI7czoyMzoiY3NzX2J1dHRvbl9tYXJnaW5fcmlnaHQiO3M6MToiMCI7czoxNDoiYnV0dG9uX2ljb25faWQiO3M6MzoiY29nIjtzOjIxOiJjc3NfYnV0dG9uX2ljb25fY29sb3IiO3M6NzoiI2IwYzhlYiI7czo1OiJ0aXRsZSI7czoxNDoiRmVicnVhcnksIDIwMTQiO3M6NzoiY29udGVudCI7czo5NToiPHA+QWVuZWFuIGV1IGxlbyBxdWFtIG9ybmFyZSBzZW0gbGFjaW5pYSBxdWFtIHZlbmVuYXRpcyB2ZXN0aWJ1bHVtLiBNYWVjZW5hcyBzZWQgZGlhbSBlZ2V0LjwvcD4iO3M6MTI6ImJ1dHRvbl90aXRsZSI7czoxMzoiQ0xJQ0sgVE8gRURJVCI7czo5OiJjc3NfcmVzX3QiO3M6NzoiZW5hYmxlZCI7czoyMzoiY3NzX3Jlc190X21hcmdpbl9ib3R0b20iO3M6MToiMCI7czoyODoiY3NzX3Jlc190X3BhZGRpbmdfaG9yaXpvbnRhbCI7czoyOiIxMyI7czoyNToiY3NzX3Jlc190X2ljb25fbWFyZ2luX3RvcCI7czozOiItNTUiO3M6Mjc6ImNzc19yZXNfdF9pY29uX21hcmdpbl9yaWdodCI7czoxOiIwIjtzOjI4OiJjc3NfcmVzX3RfaWNvbl93cmFwcGVyX3dpZHRoIjtzOjM6IjExMCI7czoyMDoiY3NzX3Jlc190X2ljb25fd2lkdGgiO3M6MjoiNDciO3M6MjU6ImNzc19yZXNfdF90aXRsZV9mb250X3NpemUiO3M6MjoiMTciO3M6Mjc6ImNzc19yZXNfdF90aXRsZV9saW5lX2hlaWdodCI7czoyOiIxNyI7czoyMjoiY3NzX3Jlc190X3RpdGxlX21hcmdpbiI7czoyOiIyMSI7czoyNzoiY3NzX3Jlc190X2NvbnRlbnRfZm9udF9zaXplIjtzOjI6IjE4IjtzOjI5OiJjc3NfcmVzX3RfY29udGVudF9saW5lX2hlaWdodCI7czoyOiIyMyI7czoyNDoiY3NzX3Jlc190X2NvbnRlbnRfbWFyZ2luIjtzOjI6IjQwIjtzOjI2OiJjc3NfcmVzX3RfYnV0dG9uX2ZvbnRfc2l6ZSI7czoyOiIxMSI7czozMzoiY3NzX3Jlc190X2J1dHRvbl9wYWRkaW5nX3ZlcnRpY2FsIjtzOjI6IjEzIjtzOjM1OiJjc3NfcmVzX3RfYnV0dG9uX3BhZGRpbmdfaG9yaXpvbnRhbCI7czoyOiIxNiI7czoyODoiY3NzX3Jlc190X2J1dHRvbl9pY29uX21hcmdpbiI7czoxOiI1IjtzOjk6ImNzc19yZXNfcCI7czo3OiJlbmFibGVkIjtzOjIzOiJjc3NfcmVzX3BfbWFyZ2luX2JvdHRvbSI7czoyOiI1MSI7czoyNToiY3NzX3Jlc19wX2ljb25fbWFyZ2luX3RvcCI7czozOiItNTAiO3M6Mjc6ImNzc19yZXNfcF9pY29uX21hcmdpbl9yaWdodCI7czoxOiIwIjtzOjI4OiJjc3NfcmVzX3BfaWNvbl93cmFwcGVyX3dpZHRoIjtzOjM6IjEwMCI7czoyMDoiY3NzX3Jlc19wX2ljb25fd2lkdGgiO3M6MjoiNDIiO3M6MjU6ImNzc19yZXNfcF90aXRsZV9mb250X3NpemUiO3M6MjoiMTYiO3M6Mjc6ImNzc19yZXNfcF90aXRsZV9saW5lX2hlaWdodCI7czoyOiIxNyI7czoyMjoiY3NzX3Jlc19wX3RpdGxlX21hcmdpbiI7czoyOiIyMSI7czoyNzoiY3NzX3Jlc19wX2NvbnRlbnRfZm9udF9zaXplIjtzOjI6IjE3IjtzOjI0OiJjc3NfcmVzX3BfY29udGVudF9tYXJnaW4iO3M6MjoiNDAiO3M6MjY6ImNzc19yZXNfcF9idXR0b25fZm9udF9zaXplIjtzOjI6IjExIjtzOjMzOiJjc3NfcmVzX3BfYnV0dG9uX3BhZGRpbmdfdmVydGljYWwiO3M6MjoiMTMiO3M6MzU6ImNzc19yZXNfcF9idXR0b25fcGFkZGluZ19ob3Jpem9udGFsIjtzOjI6IjE2IjtzOjI4OiJjc3NfcmVzX3BfYnV0dG9uX2ljb25fbWFyZ2luIjtzOjE6IjUiO3M6MTg6Im1vZHVsZV9pbnN0YW5jZV9pZCI7aTo1NTM1O3M6NzoicG9zdF9pZCI7czo0OiIxMjYzIjtzOjk6Im1vZHVsZV9pZCI7czoxMzoiRFNMQ19JbmZvX0JveCI7fQ==[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
[dslc_modules_section type="wrapped" columns_spacing="nospacing" border_color="" border_width="0" border_style="solid" border="top bottom" bg_color="" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="0" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="no" first="yes" size="6"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="6"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
[dslc_modules_section type="wrapped" columns_spacing="spacing" border_color="" border_width="0" border_style="solid" border="top bottom" bg_color="" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="0" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="no" first="yes" size="3"] [/dslc_modules_area] 
[dslc_modules_area last="no" first="no" size="6"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
[dslc_modules_section type="wrapped" columns_spacing="spacing" border_color="" border_width="0" border_style="solid" border="top bottom" bg_color="" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="0" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo5OntzOjY6ImhlaWdodCI7czoyOiI2MCI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6OToiY3NzX3Jlc190IjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc190X2hlaWdodCI7czoyOiIzMCI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czoxMjoicmVzX3BfaGVpZ2h0IjtzOjI6IjE1IjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6NTU0NjtzOjc6InBvc3RfaWQiO3M6NDoiMTI2MyI7czo5OiJtb2R1bGVfaWQiO3M6MTQ6IkRTTENfU2VwYXJhdG9yIjt9[/dslc_module] [/dslc_modules_area] [/dslc_modules_section]
 ',
			'section' => 'original'
		);

		$dslc_var_templates['dslc-pricing-page'] = array(
			'title' => __( 'Pricing Page', 'dslc_string' ),
			'id' => 'dslc-pricing-page',
			'code' => '[dslc_modules_section type="wrapped" columns_spacing="spacing" border_color="rgb(237, 237, 237)" border_width="1" border_style="solid" border="top " bg_color="" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="0" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo5OntzOjY6ImhlaWdodCI7czoyOiI0MCI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6OToiY3NzX3Jlc190IjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc190X2hlaWdodCI7czoyOiIyMCI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czoxMjoicmVzX3BfaGVpZ2h0IjtzOjI6IjIwIjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6NTU5MTtzOjc6InBvc3RfaWQiO3M6NDoiMTI2MyI7czo5OiJtb2R1bGVfaWQiO3M6MTQ6IkRTTENfU2VwYXJhdG9yIjt9[/dslc_module] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
[dslc_modules_section type="wrapped" columns_spacing="spacing" border_color="" border_width="0" border_style="solid" border="top bottom" bg_color="" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="0" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo5OntzOjE2OiJjc3NfYm9yZGVyX2NvbG9yIjtzOjE3OiJyZ2IoOTYsIDEyMCwgMTM5KSI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6OToiY3NzX3Jlc190IjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc190X2hlaWdodCI7czoyOiIxNSI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czoxMjoicmVzX3BfaGVpZ2h0IjtzOjE6IjEiO3M6MTg6Im1vZHVsZV9pbnN0YW5jZV9pZCI7aTo4NjQ3O3M6NzoicG9zdF9pZCI7czo0OiIxMjYzIjtzOjk6Im1vZHVsZV9pZCI7czoxNDoiRFNMQ19TZXBhcmF0b3IiO30=[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="no" first="yes" size="4"] 
[dslc_module]YTo1MDp7czo3OiJjb250ZW50IjtzOjE3OiI8cD5GUkVFIFRSSUFMPC9wPiI7czoxNzoiY3NzX21haW5fYmdfY29sb3IiO3M6MTc6InJnYigxNjksIDIwNywgNDQpIjtzOjIxOiJjc3NfbWFpbl9ib3JkZXJfY29sb3IiO3M6MTc6InJnYig4NSwgMTYyLCAyMTgpIjtzOjIwOiJjc3NfbWFpbl9ib3JkZXJfdHJibCI7czo3OiJib3R0b20gIjtzOjI1OiJjc3NfbWFpbl9wYWRkaW5nX3ZlcnRpY2FsIjtzOjI6IjE2IjtzOjI3OiJjc3NfbWFpbl9wYWRkaW5nX2hvcml6b250YWwiO3M6MjoiMjUiO3M6MTQ6ImNzc19tYWluX2NvbG9yIjtzOjE4OiJyZ2IoMjU1LCAyNTUsIDI1NSkiO3M6MTg6ImNzc19tYWluX2ZvbnRfc2l6ZSI7czoyOiIxNyI7czoyMDoiY3NzX21haW5fZm9udF93ZWlnaHQiO3M6MzoiNDAwIjtzOjIwOiJjc3NfbWFpbl9saW5lX2hlaWdodCI7czoyOiIyMiI7czoyMjoiY3NzX21haW5fbWFyZ2luX2JvdHRvbSI7czoxOiIwIjtzOjE5OiJjc3NfbWFpbl90ZXh0X2FsaWduIjtzOjY6ImNlbnRlciI7czoxNjoiY3NzX2gxX2ZvbnRfc2l6ZSI7czoyOiI2NiI7czoxODoiY3NzX2gxX2ZvbnRfd2VpZ2h0IjtzOjM6IjIwMCI7czoxODoiY3NzX2gxX2xpbmVfaGVpZ2h0IjtzOjI6IjcwIjtzOjIwOiJjc3NfaDFfbWFyZ2luX2JvdHRvbSI7czoyOiIzMCI7czoxNjoiY3NzX2gyX2ZvbnRfc2l6ZSI7czoyOiIxMyI7czoxODoiY3NzX2gyX2ZvbnRfd2VpZ2h0IjtzOjM6IjQwMCI7czoxODoiY3NzX2gyX2ZvbnRfZmFtaWx5IjtzOjk6Ik9wZW4gU2FucyI7czoxODoiY3NzX2gyX2xpbmVfaGVpZ2h0IjtzOjI6IjIyIjtzOjIwOiJjc3NfaDJfbWFyZ2luX2JvdHRvbSI7czoyOiIxNSI7czoxNjoiY3NzX2gzX2ZvbnRfc2l6ZSI7czoyOiIxMyI7czoxODoiY3NzX2gzX2ZvbnRfd2VpZ2h0IjtzOjM6IjQwMCI7czoxODoiY3NzX2gzX2ZvbnRfZmFtaWx5IjtzOjk6Ik9wZW4gU2FucyI7czoxODoiY3NzX2gzX2xpbmVfaGVpZ2h0IjtzOjI6IjIyIjtzOjIwOiJjc3NfaDNfbWFyZ2luX2JvdHRvbSI7czoyOiIxNSI7czoxNjoiY3NzX2g0X2ZvbnRfc2l6ZSI7czoyOiIxMyI7czoxODoiY3NzX2g0X2ZvbnRfd2VpZ2h0IjtzOjM6IjQwMCI7czoxODoiY3NzX2g0X2ZvbnRfZmFtaWx5IjtzOjk6Ik9wZW4gU2FucyI7czoxODoiY3NzX2g0X2xpbmVfaGVpZ2h0IjtzOjI6IjIyIjtzOjIwOiJjc3NfaDRfbWFyZ2luX2JvdHRvbSI7czoyOiIxNSI7czoxNjoiY3NzX2g1X2ZvbnRfc2l6ZSI7czoyOiIxMyI7czoxODoiY3NzX2g1X2ZvbnRfd2VpZ2h0IjtzOjM6IjQwMCI7czoxODoiY3NzX2g1X2ZvbnRfZmFtaWx5IjtzOjk6Ik9wZW4gU2FucyI7czoxODoiY3NzX2g1X2xpbmVfaGVpZ2h0IjtzOjI6IjIyIjtzOjIwOiJjc3NfaDVfbWFyZ2luX2JvdHRvbSI7czoyOiIxNSI7czoxOToiY3NzX2g2X2JvcmRlcl93aWR0aCI7czowOiIiO3M6MTg6ImNzc19oNl9ib3JkZXJfdHJibCI7czowOiIiO3M6MjQ6ImNzc19oNl9ib3JkZXJfcmFkaXVzX3RvcCI7czowOiIiO3M6Mjc6ImNzc19oNl9ib3JkZXJfcmFkaXVzX2JvdHRvbSI7czowOiIiO3M6MTY6ImNzc19oNl9mb250X3NpemUiO3M6MjoiMTMiO3M6MTg6ImNzc19oNl9mb250X3dlaWdodCI7czozOiI0MDAiO3M6MTg6ImNzc19oNl9mb250X2ZhbWlseSI7czo5OiJPcGVuIFNhbnMiO3M6MTg6ImNzc19oNl9saW5lX2hlaWdodCI7czoyOiIyMiI7czoyMDoiY3NzX2g2X21hcmdpbl9ib3R0b20iO3M6MjoiMTUiO3M6MjM6ImNzc19oNl9wYWRkaW5nX3ZlcnRpY2FsIjtzOjA6IiI7czoyNToiY3NzX2g2X3BhZGRpbmdfaG9yaXpvbnRhbCI7czowOiIiO3M6MTg6Im1vZHVsZV9pbnN0YW5jZV9pZCI7aTo4NjQ4O3M6NzoicG9zdF9pZCI7czozOiIxOTciO3M6OToibW9kdWxlX2lkIjtzOjE2OiJEU0xDX1RleHRfU2ltcGxlIjt9[/dslc_module] 
[dslc_module]YTo4MTp7czo4OiJlbGVtZW50cyI7czoyNToiaWNvbiB0aXRsZSBjb250ZW50IGJ1dHRvbiI7czoxMDoidGV4dF9hbGlnbiI7czo2OiJjZW50ZXIiO3M6MTI6ImNzc19iZ19jb2xvciI7czoxNzoicmdiKDE2MSwgMTk4LCAzOSkiO3M6MTc6ImNzc19tYXJnaW5fYm90dG9tIjtzOjE6IjAiO3M6MjA6ImNzc19wYWRkaW5nX3ZlcnRpY2FsIjtzOjI6IjU3IjtzOjIyOiJjc3NfcGFkZGluZ19ob3Jpem9udGFsIjtzOjI6IjUxIjtzOjIxOiJjc3NfaWNvbl9ib3JkZXJfY29sb3IiO3M6MDoiIjtzOjIxOiJjc3NfaWNvbl9ib3JkZXJfd2lkdGgiO3M6MToiMCI7czoyMjoiY3NzX2ljb25fYm9yZGVyX3JhZGl1cyI7czozOiIxMDAiO3M6MTQ6ImNzc19pY29uX2NvbG9yIjtzOjE5OiJyZ2JhKDAsIDAsIDAsIDAuNDQpIjtzOjc6Imljb25faWQiO3M6ODoiZXh0LWZsYWciO3M6MjE6ImNzc19pY29uX21hcmdpbl9yaWdodCI7czoxOiIwIjtzOjEzOiJpY29uX3Bvc2l0aW9uIjtzOjU6ImFib3ZlIjtzOjIyOiJjc3NfaWNvbl93cmFwcGVyX3dpZHRoIjtzOjI6IjkwIjtzOjE0OiJjc3NfaWNvbl93aWR0aCI7czoyOiI3MCI7czoxNToiY3NzX3RpdGxlX2NvbG9yIjtzOjE4OiJyZ2IoMjU1LCAyNTUsIDI1NSkiO3M6MTk6ImNzc190aXRsZV9mb250X3NpemUiO3M6MjoiNTkiO3M6MjE6ImNzc190aXRsZV9mb250X2ZhbWlseSI7czo0OiJMYXRvIjtzOjIxOiJjc3NfdGl0bGVfbGluZV9oZWlnaHQiO3M6MjoiNDkiO3M6MTY6ImNzc190aXRsZV9tYXJnaW4iO3M6MjoiMzYiO3M6MTc6ImNzc19jb250ZW50X2NvbG9yIjtzOjE5OiJyZ2JhKDAsIDAsIDAsIDAuNjcpIjtzOjIxOiJjc3NfY29udGVudF9mb250X3NpemUiO3M6MjoiMTciO3M6MjM6ImNzc19jb250ZW50X2ZvbnRfd2VpZ2h0IjtzOjM6IjMwMCI7czoyMzoiY3NzX2NvbnRlbnRfbGluZV9oZWlnaHQiO3M6MjoiMjciO3M6MTg6ImNzc19jb250ZW50X21hcmdpbiI7czoyOiI0MSI7czoxOToiY3NzX2J1dHRvbl9iZ19jb2xvciI7czoxNzoicmdiKDE4OCwgMjI4LCA1NCkiO3M6MjU6ImNzc19idXR0b25fYmdfY29sb3JfaG92ZXIiO3M6MTc6InJnYigyMDgsIDI1MCwgNzApIjtzOjIyOiJjc3NfYnV0dG9uX2JvcmRlcl90cmJsIjtzOjc6ImJvdHRvbSAiO3M6MjM6ImNzc19idXR0b25fYm9yZGVyX2NvbG9yIjtzOjE4OiJyZ2JhKDAsIDAsIDAsIDAuMikiO3M6Mjk6ImNzc19idXR0b25fYm9yZGVyX2NvbG9yX2hvdmVyIjtzOjE5OiJyZ2JhKDAsIDAsIDAsIDAuMjUpIjtzOjE2OiJjc3NfYnV0dG9uX2NvbG9yIjtzOjE4OiJyZ2JhKDAsIDAsIDAsIDAuNikiO3M6MjI6ImNzc19idXR0b25fY29sb3JfaG92ZXIiO3M6MTg6InJnYmEoMCwgMCwgMCwgMC42KSI7czoyMDoiY3NzX2J1dHRvbl9mb250X3NpemUiO3M6MjoiMjMiO3M6MjI6ImNzc19idXR0b25fZm9udF93ZWlnaHQiO3M6MzoiMzAwIjtzOjIxOiJjc3NfYnV0dG9uX21hcmdpbl90b3AiO3M6MjoiMTgiO3M6MjM6ImNzc19idXR0b25fbWFyZ2luX3JpZ2h0IjtzOjE6IjAiO3M6Mjc6ImNzc19idXR0b25fcGFkZGluZ192ZXJ0aWNhbCI7czoyOiIyMCI7czoyOToiY3NzX2J1dHRvbl9wYWRkaW5nX2hvcml6b250YWwiO3M6MjoiMzAiO3M6MTQ6ImJ1dHRvbl9pY29uX2lkIjtzOjg6ImV4dC1saWtlIjtzOjIxOiJjc3NfYnV0dG9uX2ljb25fY29sb3IiO3M6MTg6InJnYmEoMCwgMCwgMCwgMC42KSI7czo1OiJ0aXRsZSI7czo4OiJGUkVFPGJyPiI7czo3OiJjb250ZW50IjtzOjUyOiI8cD5ObyBoaWRkZW4gZmVlcy4gTm8gaGlnaC1wcmVzc3VyZSBzYWxlc3Blb3BsZS48L3A+IjtzOjEyOiJidXR0b25fdGl0bGUiO3M6OToiU3RhcnQgTm93IjtzOjk6ImNzc19yZXNfdCI7czo3OiJlbmFibGVkIjtzOjIzOiJjc3NfcmVzX3RfbWFyZ2luX2JvdHRvbSI7czoxOiIwIjtzOjI2OiJjc3NfcmVzX3RfcGFkZGluZ192ZXJ0aWNhbCI7czoyOiI1MCI7czoyODoiY3NzX3Jlc190X3BhZGRpbmdfaG9yaXpvbnRhbCI7czoyOiIxMCI7czoyNzoiY3NzX3Jlc190X2ljb25fbWFyZ2luX3JpZ2h0IjtzOjE6IjAiO3M6Mjg6ImNzc19yZXNfdF9pY29uX3dyYXBwZXJfd2lkdGgiO3M6MjoiOTAiO3M6MjA6ImNzc19yZXNfdF9pY29uX3dpZHRoIjtzOjI6IjcwIjtzOjI1OiJjc3NfcmVzX3RfdGl0bGVfZm9udF9zaXplIjtzOjI6IjU0IjtzOjI3OiJjc3NfcmVzX3RfdGl0bGVfbGluZV9oZWlnaHQiO3M6MjoiNDQiO3M6MjI6ImNzc19yZXNfdF90aXRsZV9tYXJnaW4iO3M6MjoiMzYiO3M6Mjc6ImNzc19yZXNfdF9jb250ZW50X2ZvbnRfc2l6ZSI7czoyOiIxNiI7czoyOToiY3NzX3Jlc190X2NvbnRlbnRfbGluZV9oZWlnaHQiO3M6MjoiMjQiO3M6MjQ6ImNzc19yZXNfdF9jb250ZW50X21hcmdpbiI7czoyOiI2OCI7czoyNjoiY3NzX3Jlc190X2J1dHRvbl9mb250X3NpemUiO3M6MjoiMjAiO3M6MzM6ImNzc19yZXNfdF9idXR0b25fcGFkZGluZ192ZXJ0aWNhbCI7czoyOiIxNyI7czozNToiY3NzX3Jlc190X2J1dHRvbl9wYWRkaW5nX2hvcml6b250YWwiO3M6MjoiMjciO3M6Mjg6ImNzc19yZXNfdF9idXR0b25faWNvbl9tYXJnaW4iO3M6MToiNSI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czoyMzoiY3NzX3Jlc19wX21hcmdpbl9ib3R0b20iO3M6MToiMCI7czoyNjoiY3NzX3Jlc19wX3BhZGRpbmdfdmVydGljYWwiO3M6MjoiMzAiO3M6Mjg6ImNzc19yZXNfcF9wYWRkaW5nX2hvcml6b250YWwiO3M6MjoiMTAiO3M6MjU6ImNzc19yZXNfcF9pY29uX21hcmdpbl90b3AiO3M6MToiMCI7czoyNzoiY3NzX3Jlc19wX2ljb25fbWFyZ2luX3JpZ2h0IjtzOjE6IjAiO3M6Mjg6ImNzc19yZXNfcF9pY29uX3dyYXBwZXJfd2lkdGgiO3M6MjoiOTAiO3M6MjA6ImNzc19yZXNfcF9pY29uX3dpZHRoIjtzOjI6IjcwIjtzOjI1OiJjc3NfcmVzX3BfdGl0bGVfZm9udF9zaXplIjtzOjI6IjU5IjtzOjI3OiJjc3NfcmVzX3BfdGl0bGVfbGluZV9oZWlnaHQiO3M6MjoiNDkiO3M6MjI6ImNzc19yZXNfcF90aXRsZV9tYXJnaW4iO3M6MjoiMjgiO3M6Mjc6ImNzc19yZXNfcF9jb250ZW50X2ZvbnRfc2l6ZSI7czoyOiIxNiI7czoyOToiY3NzX3Jlc19wX2NvbnRlbnRfbGluZV9oZWlnaHQiO3M6MjoiMjQiO3M6MjQ6ImNzc19yZXNfcF9jb250ZW50X21hcmdpbiI7czoyOiIzNiI7czoyNjoiY3NzX3Jlc19wX2J1dHRvbl9mb250X3NpemUiO3M6MjoiMjEiO3M6MzM6ImNzc19yZXNfcF9idXR0b25fcGFkZGluZ192ZXJ0aWNhbCI7czoyOiIxNSI7czozNToiY3NzX3Jlc19wX2J1dHRvbl9wYWRkaW5nX2hvcml6b250YWwiO3M6MjoiMjUiO3M6Mjg6ImNzc19yZXNfcF9idXR0b25faWNvbl9tYXJnaW4iO3M6MToiNSI7czoxODoibW9kdWxlX2luc3RhbmNlX2lkIjtpOjg2NDk7czo3OiJwb3N0X2lkIjtzOjQ6IjEyNjMiO3M6OToibW9kdWxlX2lkIjtzOjEzOiJEU0xDX0luZm9fQm94Ijt9[/dslc_module] 
[dslc_module]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[/dslc_module] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="no" first="no" size="4"] 
[dslc_module]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[/dslc_module] 
[dslc_module]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[/dslc_module] 
[dslc_module]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[/dslc_module] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="4"] 
[dslc_module]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[/dslc_module] 
[dslc_module]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[/dslc_module] 
[dslc_module]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[/dslc_module] 
[dslc_module]YTo1Mjp7czo3OiJjb250ZW50IjtzOjA6IiI7czoxNzoiY3NzX21haW5fYmdfY29sb3IiO3M6MTg6InJnYigyNDcsIDI0NywgMjQ3KSI7czoyMToiY3NzX21haW5fYm9yZGVyX2NvbG9yIjtzOjE4OiJyZ2IoMjE2LCAyMTYsIDIxNikiO3M6MjE6ImNzc19tYWluX2JvcmRlcl93aWR0aCI7czoxOiIyIjtzOjIwOiJjc3NfbWFpbl9ib3JkZXJfdHJibCI7czo3OiJib3R0b20gIjtzOjE3OiJjc3NfbWFyZ2luX2JvdHRvbSI7czoyOiIzMCI7czoyNToiY3NzX21haW5fcGFkZGluZ192ZXJ0aWNhbCI7czoyOiIxNiI7czoyNzoiY3NzX21haW5fcGFkZGluZ19ob3Jpem9udGFsIjtzOjI6IjI1IjtzOjE0OiJjc3NfbWFpbl9jb2xvciI7czoxODoicmdiKDI1NSwgMjU1LCAyNTUpIjtzOjE4OiJjc3NfbWFpbl9mb250X3NpemUiO3M6MjoiMTciO3M6MjA6ImNzc19tYWluX2ZvbnRfd2VpZ2h0IjtzOjM6IjQwMCI7czoyMDoiY3NzX21haW5fbGluZV9oZWlnaHQiO3M6MjoiMjIiO3M6MjI6ImNzc19tYWluX21hcmdpbl9ib3R0b20iO3M6MToiMCI7czoxOToiY3NzX21haW5fdGV4dF9hbGlnbiI7czo2OiJjZW50ZXIiO3M6MTY6ImNzc19oMV9mb250X3NpemUiO3M6MjoiNjYiO3M6MTg6ImNzc19oMV9mb250X3dlaWdodCI7czozOiIyMDAiO3M6MTg6ImNzc19oMV9saW5lX2hlaWdodCI7czoyOiI3MCI7czoyMDoiY3NzX2gxX21hcmdpbl9ib3R0b20iO3M6MjoiMzAiO3M6MTY6ImNzc19oMl9mb250X3NpemUiO3M6MjoiMTMiO3M6MTg6ImNzc19oMl9mb250X3dlaWdodCI7czozOiI0MDAiO3M6MTg6ImNzc19oMl9mb250X2ZhbWlseSI7czo5OiJPcGVuIFNhbnMiO3M6MTg6ImNzc19oMl9saW5lX2hlaWdodCI7czoyOiIyMiI7czoyMDoiY3NzX2gyX21hcmdpbl9ib3R0b20iO3M6MjoiMTUiO3M6MTY6ImNzc19oM19mb250X3NpemUiO3M6MjoiMTMiO3M6MTg6ImNzc19oM19mb250X3dlaWdodCI7czozOiI0MDAiO3M6MTg6ImNzc19oM19mb250X2ZhbWlseSI7czo5OiJPcGVuIFNhbnMiO3M6MTg6ImNzc19oM19saW5lX2hlaWdodCI7czoyOiIyMiI7czoyMDoiY3NzX2gzX21hcmdpbl9ib3R0b20iO3M6MjoiMTUiO3M6MTY6ImNzc19oNF9mb250X3NpemUiO3M6MjoiMTMiO3M6MTg6ImNzc19oNF9mb250X3dlaWdodCI7czozOiI0MDAiO3M6MTg6ImNzc19oNF9mb250X2ZhbWlseSI7czo5OiJPcGVuIFNhbnMiO3M6MTg6ImNzc19oNF9saW5lX2hlaWdodCI7czoyOiIyMiI7czoyMDoiY3NzX2g0X21hcmdpbl9ib3R0b20iO3M6MjoiMTUiO3M6MTY6ImNzc19oNV9mb250X3NpemUiO3M6MjoiMTMiO3M6MTg6ImNzc19oNV9mb250X3dlaWdodCI7czozOiI0MDAiO3M6MTg6ImNzc19oNV9mb250X2ZhbWlseSI7czo5OiJPcGVuIFNhbnMiO3M6MTg6ImNzc19oNV9saW5lX2hlaWdodCI7czoyOiIyMiI7czoyMDoiY3NzX2g1X21hcmdpbl9ib3R0b20iO3M6MjoiMTUiO3M6MTk6ImNzc19oNl9ib3JkZXJfd2lkdGgiO3M6MDoiIjtzOjE4OiJjc3NfaDZfYm9yZGVyX3RyYmwiO3M6MDoiIjtzOjI0OiJjc3NfaDZfYm9yZGVyX3JhZGl1c190b3AiO3M6MDoiIjtzOjI3OiJjc3NfaDZfYm9yZGVyX3JhZGl1c19ib3R0b20iO3M6MDoiIjtzOjE2OiJjc3NfaDZfZm9udF9zaXplIjtzOjI6IjEzIjtzOjE4OiJjc3NfaDZfZm9udF93ZWlnaHQiO3M6MzoiNDAwIjtzOjE4OiJjc3NfaDZfZm9udF9mYW1pbHkiO3M6OToiT3BlbiBTYW5zIjtzOjE4OiJjc3NfaDZfbGluZV9oZWlnaHQiO3M6MjoiMjIiO3M6MjA6ImNzc19oNl9tYXJnaW5fYm90dG9tIjtzOjI6IjE1IjtzOjIzOiJjc3NfaDZfcGFkZGluZ192ZXJ0aWNhbCI7czowOiIiO3M6MjU6ImNzc19oNl9wYWRkaW5nX2hvcml6b250YWwiO3M6MDoiIjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6ODY1OTtzOjc6InBvc3RfaWQiO3M6MzoiMTk3IjtzOjk6Im1vZHVsZV9pZCI7czoxNjoiRFNMQ19UZXh0X1NpbXBsZSI7fQ==[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="no" first="yes" size="6"] 
[dslc_module]YToyODp7czoxMToiYnV0dG9uX3RleHQiO3M6MjE6IkZyZWUgU0VPIENvbnN1bHRhdGlvbiI7czo5OiJjc3NfYWxpZ24iO3M6NToicmlnaHQiO3M6MTI6ImNzc19iZ19jb2xvciI7czoxNzoicmdiKDg2LCAxNzQsIDIyNykiO3M6MTY6ImNzc19ib3JkZXJfY29sb3IiO3M6MjU6InJnYmEoMTI1LCAxOTksIDI1MCwgMC4zNSkiO3M6MjI6ImNzc19ib3JkZXJfY29sb3JfaG92ZXIiO3M6MDoiIjtzOjE2OiJjc3NfYm9yZGVyX3dpZHRoIjtzOjE6IjAiO3M6MTc6ImNzc19tYXJnaW5fYm90dG9tIjtzOjE6IjAiO3M6MjA6ImNzc19wYWRkaW5nX3ZlcnRpY2FsIjtzOjI6IjE2IjtzOjIyOiJjc3NfcGFkZGluZ19ob3Jpem9udGFsIjtzOjI6IjI0IjtzOjE2OiJjc3NfYnV0dG9uX2NvbG9yIjtzOjE4OiJyZ2IoMjU1LCAyNTUsIDI1NSkiO3M6MjI6ImNzc19idXR0b25fY29sb3JfaG92ZXIiO3M6NzoiI2ZmZmZmZiI7czoyMDoiY3NzX2J1dHRvbl9mb250X3NpemUiO3M6MjoiMjMiO3M6MTQ6ImJ1dHRvbl9pY29uX2lkIjtzOjEwOiJleHQtYnViYmxlIjtzOjIzOiJjc3NfcmVzX3RfbWFyZ2luX2JvdHRvbSI7czoxOiIwIjtzOjI2OiJjc3NfcmVzX3RfcGFkZGluZ192ZXJ0aWNhbCI7czoyOiIxMiI7czoyODoiY3NzX3Jlc190X3BhZGRpbmdfaG9yaXpvbnRhbCI7czoyOiIxMiI7czoyNjoiY3NzX3Jlc190X2J1dHRvbl9mb250X3NpemUiO3M6MjoiMTEiO3M6MjE6ImNzc19yZXNfdF9pY29uX21hcmdpbiI7czoxOiI1IjtzOjk6ImNzc19yZXNfcCI7czo3OiJlbmFibGVkIjtzOjIzOiJjc3NfcmVzX3BfbWFyZ2luX2JvdHRvbSI7czoyOiIyMCI7czoyNjoiY3NzX3Jlc19wX3BhZGRpbmdfdmVydGljYWwiO3M6MjoiMTgiO3M6Mjg6ImNzc19yZXNfcF9wYWRkaW5nX2hvcml6b250YWwiO3M6MjoiMjUiO3M6MjY6ImNzc19yZXNfcF9idXR0b25fZm9udF9zaXplIjtzOjI6IjE4IjtzOjIxOiJjc3NfcmVzX3BfaWNvbl9tYXJnaW4iO3M6MToiNSI7czoxNjoiY3NzX3Jlc19waF9hbGlnbiI7czo2OiJjZW50ZXIiO3M6MTg6Im1vZHVsZV9pbnN0YW5jZV9pZCI7aTo4NjYxO3M6NzoicG9zdF9pZCI7czo0OiIxMjYzIjtzOjk6Im1vZHVsZV9pZCI7czoxMToiRFNMQ19CdXR0b24iO30=[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="6"] 
[dslc_module]YToyNzp7czoxMToiYnV0dG9uX3RleHQiO3M6MjA6IlJlcXVlc3QgYSBGcmVlIFF1b3RlIjtzOjEyOiJjc3NfYmdfY29sb3IiO3M6MTc6InJnYigxNjEsIDE5OCwgMzkpIjtzOjE4OiJjc3NfYmdfY29sb3JfaG92ZXIiO3M6MTc6InJnYigxMzcsIDE3NCwgMTcpIjtzOjE2OiJjc3NfYm9yZGVyX2NvbG9yIjtzOjI0OiJyZ2JhKDI0MywgMTgxLCA2OCwgMC4yNykiO3M6MjI6ImNzc19ib3JkZXJfY29sb3JfaG92ZXIiO3M6MDoiIjtzOjE2OiJjc3NfYm9yZGVyX3dpZHRoIjtzOjE6IjAiO3M6MTc6ImNzc19tYXJnaW5fYm90dG9tIjtzOjE6IjAiO3M6MjA6ImNzc19wYWRkaW5nX3ZlcnRpY2FsIjtzOjI6IjE2IjtzOjIyOiJjc3NfcGFkZGluZ19ob3Jpem9udGFsIjtzOjI6IjI0IjtzOjE2OiJjc3NfYnV0dG9uX2NvbG9yIjtzOjE4OiJyZ2IoMjU1LCAyNTUsIDI1NSkiO3M6MjI6ImNzc19idXR0b25fY29sb3JfaG92ZXIiO3M6NzoiI2ZmZmZmZiI7czoyMDoiY3NzX2J1dHRvbl9mb250X3NpemUiO3M6MjoiMjMiO3M6MTQ6ImJ1dHRvbl9pY29uX2lkIjtzOjEyOiJleHQtYmFua25vdGUiO3M6MjM6ImNzc19yZXNfdF9tYXJnaW5fYm90dG9tIjtzOjE6IjAiO3M6MjY6ImNzc19yZXNfdF9wYWRkaW5nX3ZlcnRpY2FsIjtzOjI6IjEyIjtzOjI4OiJjc3NfcmVzX3RfcGFkZGluZ19ob3Jpem9udGFsIjtzOjI6IjEyIjtzOjI2OiJjc3NfcmVzX3RfYnV0dG9uX2ZvbnRfc2l6ZSI7czoyOiIxMSI7czoyMToiY3NzX3Jlc190X2ljb25fbWFyZ2luIjtzOjE6IjUiO3M6OToiY3NzX3Jlc19wIjtzOjc6ImVuYWJsZWQiO3M6MjY6ImNzc19yZXNfcF9wYWRkaW5nX3ZlcnRpY2FsIjtzOjI6IjE4IjtzOjI4OiJjc3NfcmVzX3BfcGFkZGluZ19ob3Jpem9udGFsIjtzOjI6IjI5IjtzOjI2OiJjc3NfcmVzX3BfYnV0dG9uX2ZvbnRfc2l6ZSI7czoyOiIxOCI7czoyMToiY3NzX3Jlc19wX2ljb25fbWFyZ2luIjtzOjE6IjUiO3M6MTY6ImNzc19yZXNfcGhfYWxpZ24iO3M6NjoiY2VudGVyIjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6ODY2MjtzOjc6InBvc3RfaWQiO3M6NDoiMTI2MyI7czo5OiJtb2R1bGVfaWQiO3M6MTE6IkRTTENfQnV0dG9uIjt9[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YToxMDp7czoxNjoiY3NzX2JvcmRlcl9jb2xvciI7czoxNzoicmdiKDk2LCAxMjAsIDEzOSkiO3M6NjoiaGVpZ2h0IjtzOjI6IjYwIjtzOjU6InN0eWxlIjtzOjk6ImludmlzaWJsZSI7czo5OiJjc3NfcmVzX3QiO3M6NzoiZW5hYmxlZCI7czoxMjoicmVzX3RfaGVpZ2h0IjtzOjI6IjMwIjtzOjk6ImNzc19yZXNfcCI7czo3OiJlbmFibGVkIjtzOjEyOiJyZXNfcF9oZWlnaHQiO3M6MjoiMTUiO3M6MTg6Im1vZHVsZV9pbnN0YW5jZV9pZCI7aTo4NjYzO3M6NzoicG9zdF9pZCI7czo0OiIxMjYzIjtzOjk6Im1vZHVsZV9pZCI7czoxNDoiRFNMQ19TZXBhcmF0b3IiO30=[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
[dslc_modules_section type="wrapped" columns_spacing="spacing" border_color="rgb(241, 241, 241)" border_width="1" border_style="solid" border="top " bg_color="" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="20" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo3OntzOjY6ImhlaWdodCI7czoyOiIxMCI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6OToiY3NzX3Jlc19wIjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc19wX2hlaWdodCI7czoxOiI1IjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO3M6NDoiMTczNiI7czo3OiJwb3N0X2lkIjtzOjM6IjE5NyI7czo5OiJtb2R1bGVfaWQiO3M6MTQ6IkRTTENfU2VwYXJhdG9yIjt9[/dslc_module] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
[dslc_modules_section type="wrapped" columns_spacing="spacing" border_color="" border_width="0" border_style="solid" border="top bottom" bg_color="rgb(248, 249, 250)" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="0" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo5OntzOjY6ImhlaWdodCI7czoyOiIzNSI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6OToiY3NzX3Jlc190IjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc190X2hlaWdodCI7czoyOiIzMCI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czoxMjoicmVzX3BfaGVpZ2h0IjtzOjI6IjE1IjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6Njk0OTtzOjc6InBvc3RfaWQiO3M6NDoiMTI2MyI7czo5OiJtb2R1bGVfaWQiO3M6MTQ6IkRTTENfU2VwYXJhdG9yIjt9[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="no" first="yes" size="6"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="6"] 
[dslc_module]YToyNjp7czoxMToiYnV0dG9uX3RleHQiO3M6MTc6IkFzayB5b3VyIHF1ZXN0aW9uIjtzOjk6ImNzc19hbGlnbiI7czo1OiJyaWdodCI7czoxMjoiY3NzX2JnX2NvbG9yIjtzOjE4OiJyZ2IoMjU1LCAyNTUsIDI1NSkiO3M6MTY6ImNzc19ib3JkZXJfY29sb3IiO3M6MTg6InJnYigyNTUsIDI1NSwgMjU1KSI7czoxNzoiY3NzX2JvcmRlcl9yYWRpdXMiO3M6MToiMyI7czoxNzoiY3NzX21hcmdpbl9ib3R0b20iO3M6MjoiNDAiO3M6MjA6ImNzc19wYWRkaW5nX3ZlcnRpY2FsIjtzOjI6IjEyIjtzOjIyOiJjc3NfcGFkZGluZ19ob3Jpem9udGFsIjtzOjI6IjIwIjtzOjIyOiJjc3NfYnV0dG9uX2NvbG9yX2hvdmVyIjtzOjc6IiNmZmZmZmYiO3M6MTQ6ImJ1dHRvbl9pY29uX2lkIjtzOjEwOiJleHQtYnViYmxlIjtzOjE1OiJjc3NfaWNvbl9tYXJnaW4iO3M6MToiNSI7czoyMzoiY3NzX3Jlc190X21hcmdpbl9ib3R0b20iO3M6MToiMCI7czoyNjoiY3NzX3Jlc190X3BhZGRpbmdfdmVydGljYWwiO3M6MjoiMTIiO3M6Mjg6ImNzc19yZXNfdF9wYWRkaW5nX2hvcml6b250YWwiO3M6MjoiMTIiO3M6MjY6ImNzc19yZXNfdF9idXR0b25fZm9udF9zaXplIjtzOjI6IjExIjtzOjIxOiJjc3NfcmVzX3RfaWNvbl9tYXJnaW4iO3M6MToiNSI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czoyMzoiY3NzX3Jlc19wX21hcmdpbl9ib3R0b20iO3M6MjoiMjUiO3M6MjY6ImNzc19yZXNfcF9wYWRkaW5nX3ZlcnRpY2FsIjtzOjI6IjEyIjtzOjI4OiJjc3NfcmVzX3BfcGFkZGluZ19ob3Jpem9udGFsIjtzOjI6IjIwIjtzOjI2OiJjc3NfcmVzX3BfYnV0dG9uX2ZvbnRfc2l6ZSI7czoyOiIxNyI7czoyMToiY3NzX3Jlc19wX2ljb25fbWFyZ2luIjtzOjE6IjUiO3M6MTY6ImNzc19yZXNfcGhfYWxpZ24iO3M6NToicmlnaHQiO3M6MTg6Im1vZHVsZV9pbnN0YW5jZV9pZCI7aTo2OTUxO3M6NzoicG9zdF9pZCI7czo0OiIxMjYzIjtzOjk6Im1vZHVsZV9pZCI7czoxMToiRFNMQ19CdXR0b24iO30=[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
[dslc_modules_section type="wrapped" columns_spacing="spacing" border_color="" border_width="0" border_style="solid" border="top bottom" bg_color="rgb(248, 249, 250)" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="0" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo5OntzOjY6ImhlaWdodCI7czoyOiIxNSI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6OToiY3NzX3Jlc190IjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc190X2hlaWdodCI7czoyOiIxNSI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czoxMjoicmVzX3BfaGVpZ2h0IjtzOjE6IjEiO3M6MTg6Im1vZHVsZV9pbnN0YW5jZV9pZCI7aTo1Njk2O3M6NzoicG9zdF9pZCI7czo0OiIxMjYzIjtzOjk6Im1vZHVsZV9pZCI7czoxNDoiRFNMQ19TZXBhcmF0b3IiO30=[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="no" first="yes" size="6"] 
[dslc_module]YTo2Njp7czo4OiJlbGVtZW50cyI7czoxOToiaWNvbiB0aXRsZSBjb250ZW50ICI7czoxNzoiY3NzX21hcmdpbl9ib3R0b20iO3M6MToiMCI7czoxNzoiY3NzX2NvbnRlbnRfd2lkdGgiO3M6MjoiODUiO3M6MTc6ImNzc19pY29uX2JnX2NvbG9yIjtzOjIyOiJyZ2JhKDIwMywgMjA3LCAyMTIsIDApIjtzOjIxOiJjc3NfaWNvbl9ib3JkZXJfY29sb3IiO3M6MTg6InJnYigyMDQsIDIwNCwgMjA0KSI7czoyMjoiY3NzX2ljb25fYm9yZGVyX3JhZGl1cyI7czozOiIxMDAiO3M6MTQ6ImNzc19pY29uX2NvbG9yIjtzOjE4OiJyZ2IoMTg4LCAxODgsIDE4OCkiO3M6NzoiaWNvbl9pZCI7czoxMjoiZXh0LXF1ZXN0aW9uIjtzOjE5OiJjc3NfaWNvbl9tYXJnaW5fdG9wIjtzOjE6IjMiO3M6MjE6ImNzc19pY29uX21hcmdpbl9yaWdodCI7czoyOiIzMCI7czoyMjoiY3NzX2ljb25fd3JhcHBlcl93aWR0aCI7czoyOiIyOCI7czoxNDoiY3NzX2ljb25fd2lkdGgiO3M6MjoiMTciO3M6MTU6ImNzc190aXRsZV9jb2xvciI7czo3OiIjM2QzZDNkIjtzOjE5OiJjc3NfdGl0bGVfZm9udF9zaXplIjtzOjI6IjIwIjtzOjIxOiJjc3NfdGl0bGVfZm9udF93ZWlnaHQiO3M6MzoiNDAwIjtzOjE2OiJjc3NfdGl0bGVfbWFyZ2luIjtzOjI6IjE0IjtzOjIxOiJjc3NfY29udGVudF9mb250X3NpemUiO3M6MjoiMTciO3M6MjM6ImNzc19jb250ZW50X2ZvbnRfd2VpZ2h0IjtzOjM6IjMwMCI7czoyMzoiY3NzX2NvbnRlbnRfbGluZV9oZWlnaHQiO3M6MjoiMjQiO3M6MTg6ImNzc19jb250ZW50X21hcmdpbiI7czoxOiIwIjtzOjE5OiJjc3NfYnV0dG9uX2JnX2NvbG9yIjtzOjc6IiM1ODkwZTUiO3M6MjU6ImNzc19idXR0b25fYmdfY29sb3JfaG92ZXIiO3M6NzoiIzNlNzNjMiI7czoyMzoiY3NzX2J1dHRvbl9ib3JkZXJfd2lkdGgiO3M6MToiMCI7czoyMzoiY3NzX2J1dHRvbl9ib3JkZXJfY29sb3IiO3M6NzoiI2Q4ZDhkOCI7czoyOToiY3NzX2J1dHRvbl9ib3JkZXJfY29sb3JfaG92ZXIiO3M6MDoiIjtzOjE2OiJjc3NfYnV0dG9uX2NvbG9yIjtzOjc6IiNmZmZmZmYiO3M6MjA6ImNzc19idXR0b25fZm9udF9zaXplIjtzOjI6IjExIjtzOjIyOiJjc3NfYnV0dG9uX2ZvbnRfd2VpZ2h0IjtzOjM6IjgwMCI7czoyMjoiY3NzX2J1dHRvbl9mb250X2ZhbWlseSI7czo5OiJPcGVuIFNhbnMiO3M6MjE6ImNzc19idXR0b25fbWFyZ2luX3RvcCI7czoxOiIwIjtzOjIzOiJjc3NfYnV0dG9uX21hcmdpbl9yaWdodCI7czoxOiIwIjtzOjE0OiJidXR0b25faWNvbl9pZCI7czozOiJjb2ciO3M6MjE6ImNzc19idXR0b25faWNvbl9jb2xvciI7czo3OiIjYjBjOGViIjtzOjU6InRpdGxlIjtzOjM4OiJJcyBTZWFyY2ggRW5naW5lIFN1Ym1pc3Npb24gTmVjZXNzYXJ5PyI7czo3OiJjb250ZW50IjtzOjI4OToiPHA+VGhlIHNpbXBsZSBhbnN3ZXIgaXMgbm8gLSBzZWFyY2ggZW5naW5lIHN1Ym1pc3Npb24gaXNu4oCZdCBuZWNlc3NhcnkuIFRoZSBtYWpvcml0eSBvZiBzZWFyY2ggZW5naW5lcyBub3dhZGF5cyAobW9zdCBub3RhYmx5IEdvb2dsZSkgY3Jhd2wgYW5kIGluZGV4IHBhZ2VzIGJ5IGZvbGxvd2luZyBsaW5rcy4gVXNpbmcgdGhhdCBsb2dpYywgYSBzaW5nbGUgaW5ib3VuZCBsaW5rIGZyb20gYW55IGFscmVhZHktaW5kZXhlZCBwYWdlIHdpbGwgaWRlbnRpZnkgeW91ciBwYWdlIHRvIHRoZSBlbmdpbmUuPC9wPiI7czoxMjoiYnV0dG9uX3RpdGxlIjtzOjEzOiJDTElDSyBUTyBFRElUIjtzOjk6ImNzc19yZXNfdCI7czo3OiJlbmFibGVkIjtzOjIzOiJjc3NfcmVzX3RfbWFyZ2luX2JvdHRvbSI7czoxOiIwIjtzOjI3OiJjc3NfcmVzX3RfaWNvbl9tYXJnaW5fcmlnaHQiO3M6MjoiMTUiO3M6Mjg6ImNzc19yZXNfdF9pY29uX3dyYXBwZXJfd2lkdGgiO3M6MjoiMjgiO3M6MjA6ImNzc19yZXNfdF9pY29uX3dpZHRoIjtzOjI6IjE3IjtzOjI1OiJjc3NfcmVzX3RfdGl0bGVfZm9udF9zaXplIjtzOjI6IjE4IjtzOjIyOiJjc3NfcmVzX3RfdGl0bGVfbWFyZ2luIjtzOjI6IjE1IjtzOjI3OiJjc3NfcmVzX3RfY29udGVudF9mb250X3NpemUiO3M6MjoiMTQiO3M6Mjk6ImNzc19yZXNfdF9jb250ZW50X2xpbmVfaGVpZ2h0IjtzOjI6IjIzIjtzOjI0OiJjc3NfcmVzX3RfY29udGVudF9tYXJnaW4iO3M6MToiMCI7czoyNjoiY3NzX3Jlc190X2J1dHRvbl9mb250X3NpemUiO3M6MjoiMTEiO3M6MzM6ImNzc19yZXNfdF9idXR0b25fcGFkZGluZ192ZXJ0aWNhbCI7czoyOiIxMyI7czozNToiY3NzX3Jlc190X2J1dHRvbl9wYWRkaW5nX2hvcml6b250YWwiO3M6MjoiMTYiO3M6Mjg6ImNzc19yZXNfdF9idXR0b25faWNvbl9tYXJnaW4iO3M6MToiNSI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czoyMzoiY3NzX3Jlc19wX21hcmdpbl9ib3R0b20iO3M6MjoiMjAiO3M6MjU6ImNzc19yZXNfcF9pY29uX21hcmdpbl90b3AiO3M6MToiMCI7czoyNzoiY3NzX3Jlc19wX2ljb25fbWFyZ2luX3JpZ2h0IjtzOjI6IjE1IjtzOjI4OiJjc3NfcmVzX3BfaWNvbl93cmFwcGVyX3dpZHRoIjtzOjI6IjI4IjtzOjIwOiJjc3NfcmVzX3BfaWNvbl93aWR0aCI7czoyOiIxNyI7czoyNToiY3NzX3Jlc19wX3RpdGxlX2ZvbnRfc2l6ZSI7czoyOiIxNyI7czoyMjoiY3NzX3Jlc19wX3RpdGxlX21hcmdpbiI7czoyOiIxNSI7czoyNDoiY3NzX3Jlc19wX2NvbnRlbnRfbWFyZ2luIjtzOjE6IjAiO3M6MjY6ImNzc19yZXNfcF9idXR0b25fZm9udF9zaXplIjtzOjI6IjExIjtzOjMzOiJjc3NfcmVzX3BfYnV0dG9uX3BhZGRpbmdfdmVydGljYWwiO3M6MjoiMTMiO3M6MzU6ImNzc19yZXNfcF9idXR0b25fcGFkZGluZ19ob3Jpem9udGFsIjtzOjI6IjE2IjtzOjI4OiJjc3NfcmVzX3BfYnV0dG9uX2ljb25fbWFyZ2luIjtzOjE6IjUiO3M6MTg6Im1vZHVsZV9pbnN0YW5jZV9pZCI7aTo1Njk3O3M6NzoicG9zdF9pZCI7czo0OiIxMjYzIjtzOjk6Im1vZHVsZV9pZCI7czoxMzoiRFNMQ19JbmZvX0JveCI7fQ==[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="6"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo5OntzOjY6ImhlaWdodCI7czoyOiIzMCI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6OToiY3NzX3Jlc190IjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc190X2hlaWdodCI7czoyOiIyMCI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czoxMjoicmVzX3BfaGVpZ2h0IjtzOjE6IjEiO3M6MTg6Im1vZHVsZV9pbnN0YW5jZV9pZCI7aTo1Njk5O3M6NzoicG9zdF9pZCI7czo0OiIxMjYzIjtzOjk6Im1vZHVsZV9pZCI7czoxNDoiRFNMQ19TZXBhcmF0b3IiO30=[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
[dslc_modules_section type="wrapped" columns_spacing="spacing" border_color="" border_width="0" border_style="solid" border="top bottom" bg_color="rgb(248, 249, 250)" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="0" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="no" first="yes" size="6"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="6"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo5OntzOjY6ImhlaWdodCI7czoyOiIzMCI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6OToiY3NzX3Jlc190IjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc190X2hlaWdodCI7czoyOiIyMCI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czoxMjoicmVzX3BfaGVpZ2h0IjtzOjE6IjEiO3M6MTg6Im1vZHVsZV9pbnN0YW5jZV9pZCI7aTo1NzIwO3M6NzoicG9zdF9pZCI7czo0OiIxMjYzIjtzOjk6Im1vZHVsZV9pZCI7czoxNDoiRFNMQ19TZXBhcmF0b3IiO30=[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
[dslc_modules_section type="wrapped" columns_spacing="spacing" border_color="" border_width="0" border_style="solid" border="top bottom" bg_color="rgb(248, 249, 250)" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="0" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="no" first="yes" size="6"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="6"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo5OntzOjY6ImhlaWdodCI7czoyOiI2MiI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6OToiY3NzX3Jlc190IjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc190X2hlaWdodCI7czoyOiIzMiI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czoxMjoicmVzX3BfaGVpZ2h0IjtzOjE6IjEiO3M6MTg6Im1vZHVsZV9pbnN0YW5jZV9pZCI7aTo1NzQyO3M6NzoicG9zdF9pZCI7czo0OiIxMjYzIjtzOjk6Im1vZHVsZV9pZCI7czoxNDoiRFNMQ19TZXBhcmF0b3IiO30=[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
[dslc_modules_section type="" columns_spacing="" border_color="" border_width="0" border_style="" border="top bottom" bg_color="rgb(54, 61, 65)" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="" bg_image_position="" bg_image_size="auto" padding="30" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo3OntzOjY6ImhlaWdodCI7czoyOiIxNCI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6OToiY3NzX3Jlc19wIjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc19wX2hlaWdodCI7czoxOiIxIjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6NTc2NjtzOjc6InBvc3RfaWQiO3M6NDoiMTI2MyI7czo5OiJtb2R1bGVfaWQiO3M6MTQ6IkRTTENfU2VwYXJhdG9yIjt9[/dslc_module] 
[dslc_module]YToxNzp7czo4OiJlbGVtZW50cyI7czowOiIiO3M6MTc6ImNhcm91c2VsX2VsZW1lbnRzIjtzOjg6ImNpcmNsZXMgIjtzOjE1OiJjc3NfcXVvdGVfY29sb3IiO3M6MTg6InJnYigyNTUsIDI1NSwgMjU1KSI7czoxOToiY3NzX3F1b3RlX2ZvbnRfc2l6ZSI7czoyOiIyNCI7czoyMToiY3NzX3F1b3RlX2xpbmVfaGVpZ2h0IjtzOjI6IjM0IjtzOjE0OiJjc3NfbmFtZV9jb2xvciI7czoxODoicmdiKDI1NSwgMjU1LCAyNTUpIjtzOjE4OiJjc3NfcG9zaXRpb25fY29sb3IiO3M6MjU6InJnYmEoMjU1LCAyNTUsIDI1NSwgMC41OSkiO3M6OToiY3NzX3Jlc19wIjtzOjc6ImVuYWJsZWQiO3M6MzM6ImNzc19yZXNfcF9tYWluX3BhZGRpbmdfaG9yaXpvbnRhbCI7czoxOiIzIjtzOjI3OiJjc3NfcmVzX3BfcXVvdGVfbGluZV9oZWlnaHQiO3M6MjoiMjUiO3M6MTc6ImNzc19jaXJjbGVzX2NvbG9yIjtzOjI0OiJyZ2JhKDI1NSwgMjU1LCAyNTUsIDAuMykiO3M6MjQ6ImNzc19jaXJjbGVzX2NvbG9yX2FjdGl2ZSI7czoxODoicmdiKDI1NSwgMjU1LCAyNTUpIjtzOjIyOiJjc3NfY2lyY2xlc19tYXJnaW5fdG9wIjtzOjI6IjEwIjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6NTc2NztzOjc6InBvc3RfaWQiO3M6NDoiMTI2MyI7czoxNDoiZXhjZXJwdF9sZW5ndGgiO2k6MjA7czo5OiJtb2R1bGVfaWQiO3M6MTc6IkRTTENfVGVzdGltb25pYWxzIjt9[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
 ',
			'section' => 'original'
		);

		$dslc_var_templates['dslc-services'] = array(
			'title' => __( 'Services', 'dslc_string' ),
			'id' => 'dslc-services',
			'code' => '[dslc_modules_section type="wrapped" columns_spacing="spacing" border_color="" border_width="0" border_style="solid" border="top bottom" bg_color="" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="0" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo5OntzOjY6ImhlaWdodCI7czoyOiIzMCI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6OToiY3NzX3Jlc190IjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc190X2hlaWdodCI7czoyOiIxNSI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czoxMjoicmVzX3BfaGVpZ2h0IjtzOjI6IjE1IjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6NjMzNDtzOjc6InBvc3RfaWQiO3M6NDoiMTI2MyI7czo5OiJtb2R1bGVfaWQiO3M6MTQ6IkRTTENfU2VwYXJhdG9yIjt9[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo5OntzOjY6ImhlaWdodCI7czoyOiIzMCI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6OToiY3NzX3Jlc190IjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc190X2hlaWdodCI7czoyOiIxNSI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czoxMjoicmVzX3BfaGVpZ2h0IjtzOjI6IjE1IjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6NjMzNjtzOjc6InBvc3RfaWQiO3M6NDoiMTI2MyI7czo5OiJtb2R1bGVfaWQiO3M6MTQ6IkRTTENfU2VwYXJhdG9yIjt9[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
[dslc_modules_section type="wrapped" columns_spacing="spacing" border_color="" border_width="0" border_style="solid" border="top bottom" bg_color="rgb(255, 255, 255)" bg_image_thumb="disabled" bg_image="428" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="fixed" bg_image_position="left top" bg_image_size="auto" padding="0" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo5OntzOjY6ImhlaWdodCI7czoyOiI0MCI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6OToiY3NzX3Jlc190IjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc190X2hlaWdodCI7czoyOiIyMCI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czoxMjoicmVzX3BfaGVpZ2h0IjtzOjI6IjIwIjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6ODQ4MDtzOjc6InBvc3RfaWQiO3M6NDoiMTI2MyI7czo5OiJtb2R1bGVfaWQiO3M6MTQ6IkRTTENfU2VwYXJhdG9yIjt9[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="no" first="yes" size="4"] 
[dslc_module]YToxNTp7czo1OiJpbWFnZSI7czo0OiIxMDU3IjtzOjk6ImxpbmtfdHlwZSI7czo4OiJ1cmxfc2FtZSI7czo4OiJsaW5rX3VybCI7czoxOiIjIjtzOjk6ImltYWdlX2FsdCI7czoyMjoiU29jaWFsIE1lZGlhIE1hcmtldGluZyI7czoxMToiaW1hZ2VfdGl0bGUiO3M6MTk6IkNsaWNrIHRvIGxlYXJuIG1vcmUiO3M6MTI6ImNzc19iZ19jb2xvciI7czoxNjoicmdiKDI3LCA3NSwgMTExKSI7czoyMDoiY3NzX3BhZGRpbmdfdmVydGljYWwiO3M6MjoiMTIiO3M6MTY6ImNzc19jdF9mb250X3NpemUiO3M6MjoiMTMiO3M6MTg6ImNzc19jdF9mb250X3dlaWdodCI7czozOiI0MDAiO3M6MTg6ImNzc19jdF9mb250X2ZhbWlseSI7czo5OiJPcGVuIFNhbnMiO3M6OToiY3NzX3Jlc190IjtzOjc6ImVuYWJsZWQiO3M6MjY6ImNzc19yZXNfdF9wYWRkaW5nX3ZlcnRpY2FsIjtzOjI6IjMxIjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO3M6NDoiODQ4MSI7czo3OiJwb3N0X2lkIjtzOjM6IjQyMCI7czo5OiJtb2R1bGVfaWQiO3M6MTA6IkRTTENfSW1hZ2UiO30=[/dslc_module] 
[dslc_module]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[/dslc_module] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="no" first="no" size="4"] 
[dslc_module]YToxMzp7czo1OiJpbWFnZSI7czo0OiIxMDY2IjtzOjk6ImltYWdlX2FsdCI7czoyNjoiU2VhcmNoIEVuZ2luZSBPcHRpbWl6YXRpb24iO3M6MTE6ImltYWdlX3RpdGxlIjtzOjE5OiJDbGljayB0byBsZWFybiBtb3JlIjtzOjEyOiJjc3NfYmdfY29sb3IiO3M6MTc6InJnYigyNDMsIDE3MiwgNTIpIjtzOjIwOiJjc3NfcGFkZGluZ192ZXJ0aWNhbCI7czoyOiIyMiI7czoxNjoiY3NzX2N0X2ZvbnRfc2l6ZSI7czoyOiIxMyI7czoxODoiY3NzX2N0X2ZvbnRfd2VpZ2h0IjtzOjM6IjQwMCI7czoxODoiY3NzX2N0X2ZvbnRfZmFtaWx5IjtzOjk6Ik9wZW4gU2FucyI7czo5OiJjc3NfcmVzX3QiO3M6NzoiZW5hYmxlZCI7czoyNjoiY3NzX3Jlc190X3BhZGRpbmdfdmVydGljYWwiO3M6MjoiMzEiO3M6MTg6Im1vZHVsZV9pbnN0YW5jZV9pZCI7czo0OiI4NDg0IjtzOjc6InBvc3RfaWQiO3M6MzoiNDIwIjtzOjk6Im1vZHVsZV9pZCI7czoxMDoiRFNMQ19JbWFnZSI7fQ==[/dslc_module] 
[dslc_module]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[/dslc_module] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="4"] 
[dslc_module]YToxMTp7czo1OiJpbWFnZSI7czo0OiIxMDY3IjtzOjEyOiJjc3NfYmdfY29sb3IiO3M6MTc6InJnYigxNDIsIDE2MiwgMzIpIjtzOjIwOiJjc3NfcGFkZGluZ192ZXJ0aWNhbCI7czoyOiIzMSI7czoxNjoiY3NzX2N0X2ZvbnRfc2l6ZSI7czoyOiIxMyI7czoxODoiY3NzX2N0X2ZvbnRfd2VpZ2h0IjtzOjM6IjQwMCI7czoxODoiY3NzX2N0X2ZvbnRfZmFtaWx5IjtzOjk6Ik9wZW4gU2FucyI7czo5OiJjc3NfcmVzX3QiO3M6NzoiZW5hYmxlZCI7czoyNjoiY3NzX3Jlc190X3BhZGRpbmdfdmVydGljYWwiO3M6MjoiMzEiO3M6MTg6Im1vZHVsZV9pbnN0YW5jZV9pZCI7czo0OiI4NDg3IjtzOjc6InBvc3RfaWQiO3M6MzoiNDIwIjtzOjk6Im1vZHVsZV9pZCI7czoxMDoiRFNMQ19JbWFnZSI7fQ==[/dslc_module] 
[dslc_module]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[/dslc_module] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo5OntzOjY6ImhlaWdodCI7czoyOiIxMyI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6OToiY3NzX3Jlc190IjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc190X2hlaWdodCI7czoxOiI3IjtzOjk6ImNzc19yZXNfcCI7czo3OiJlbmFibGVkIjtzOjEyOiJyZXNfcF9oZWlnaHQiO3M6MToiMSI7czoxODoibW9kdWxlX2luc3RhbmNlX2lkIjtpOjg0OTA7czo3OiJwb3N0X2lkIjtzOjQ6IjEyNjMiO3M6OToibW9kdWxlX2lkIjtzOjE0OiJEU0xDX1NlcGFyYXRvciI7fQ==[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="no" first="yes" size="4"] 
[dslc_module]YTo5OntzOjU6ImltYWdlIjtzOjQ6IjExNDgiO3M6MTI6ImNzc19iZ19jb2xvciI7czoxNzoicmdiKDQ1LCAxMTAsIDE4MCkiO3M6MjA6ImNzc19wYWRkaW5nX3ZlcnRpY2FsIjtzOjI6IjIwIjtzOjE2OiJjc3NfY3RfZm9udF9zaXplIjtzOjI6IjEzIjtzOjE4OiJjc3NfY3RfZm9udF93ZWlnaHQiO3M6MzoiNDAwIjtzOjE4OiJjc3NfY3RfZm9udF9mYW1pbHkiO3M6OToiT3BlbiBTYW5zIjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO3M6NDoiODQ5MSI7czo3OiJwb3N0X2lkIjtzOjM6IjQyMCI7czo5OiJtb2R1bGVfaWQiO3M6MTA6IkRTTENfSW1hZ2UiO30=[/dslc_module] 
[dslc_module]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[/dslc_module] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="no" first="no" size="4"] 
[dslc_module]YToxMzp7czo1OiJpbWFnZSI7czo0OiIxMTI5IjtzOjk6ImxpbmtfdHlwZSI7czo4OiJ1cmxfc2FtZSI7czo4OiJsaW5rX3VybCI7czoxOiIjIjtzOjk6ImltYWdlX2FsdCI7czoxMzoiUGF5IFBlciBDbGljayI7czoxMToiaW1hZ2VfdGl0bGUiO3M6MTg6IkNsaWNrIHRvIGxlYW4gbW9yZSI7czoxMjoiY3NzX2JnX2NvbG9yIjtzOjE2OiJyZ2IoMjEwLCA1MCwgMzApIjtzOjIwOiJjc3NfcGFkZGluZ192ZXJ0aWNhbCI7czoyOiIyMCI7czoxNjoiY3NzX2N0X2ZvbnRfc2l6ZSI7czoyOiIxMyI7czoxODoiY3NzX2N0X2ZvbnRfd2VpZ2h0IjtzOjM6IjQwMCI7czoxODoiY3NzX2N0X2ZvbnRfZmFtaWx5IjtzOjk6Ik9wZW4gU2FucyI7czoxODoibW9kdWxlX2luc3RhbmNlX2lkIjtzOjQ6Ijg0OTQiO3M6NzoicG9zdF9pZCI7czozOiI0MjAiO3M6OToibW9kdWxlX2lkIjtzOjEwOiJEU0xDX0ltYWdlIjt9[/dslc_module] 
[dslc_module]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[/dslc_module] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="4"] 
[dslc_module]YTo5OntzOjU6ImltYWdlIjtzOjQ6IjExNDYiO3M6MTI6ImNzc19iZ19jb2xvciI7czoxNzoicmdiKDM1LCAxNjMsIDE2OSkiO3M6MjA6ImNzc19wYWRkaW5nX3ZlcnRpY2FsIjtzOjI6IjIwIjtzOjE2OiJjc3NfY3RfZm9udF9zaXplIjtzOjI6IjEzIjtzOjE4OiJjc3NfY3RfZm9udF93ZWlnaHQiO3M6MzoiNDAwIjtzOjE4OiJjc3NfY3RfZm9udF9mYW1pbHkiO3M6OToiT3BlbiBTYW5zIjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO3M6NDoiODQ5NyI7czo3OiJwb3N0X2lkIjtzOjM6IjQyMCI7czo5OiJtb2R1bGVfaWQiO3M6MTA6IkRTTENfSW1hZ2UiO30=[/dslc_module] 
[dslc_module]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[/dslc_module] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo5OntzOjY6ImhlaWdodCI7czoyOiI0MCI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6OToiY3NzX3Jlc190IjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc190X2hlaWdodCI7czoyOiIyMCI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czoxMjoicmVzX3BfaGVpZ2h0IjtzOjI6IjIwIjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6ODUwMDtzOjc6InBvc3RfaWQiO3M6NDoiMTI2MyI7czo5OiJtb2R1bGVfaWQiO3M6MTQ6IkRTTENfU2VwYXJhdG9yIjt9[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
[dslc_modules_section type="wrapped" columns_spacing="spacing" border_color="" border_width="0" border_style="solid" border="top bottom" bg_color="rgb(42, 67, 87)" bg_image_thumb="disabled" bg_image="428" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="fixed" bg_image_position="left top" bg_image_size="auto" padding="0" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo5OntzOjY6ImhlaWdodCI7czoyOiI0MCI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6OToiY3NzX3Jlc190IjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc190X2hlaWdodCI7czoyOiIyMCI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czoxMjoicmVzX3BfaGVpZ2h0IjtzOjI6IjIwIjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6NjI0NjtzOjc6InBvc3RfaWQiO3M6NDoiMTI2MyI7czo5OiJtb2R1bGVfaWQiO3M6MTQ6IkRTTENfU2VwYXJhdG9yIjt9[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="no" first="yes" size="4"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="no" first="no" size="4"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="4"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo5OntzOjY6ImhlaWdodCI7czoyOiI0MCI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6OToiY3NzX3Jlc190IjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc190X2hlaWdodCI7czoyOiIyMCI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czoxMjoicmVzX3BfaGVpZ2h0IjtzOjE6IjEiO3M6MTg6Im1vZHVsZV9pbnN0YW5jZV9pZCI7aTo2MjUwO3M6NzoicG9zdF9pZCI7czo0OiIxMjYzIjtzOjk6Im1vZHVsZV9pZCI7czoxNDoiRFNMQ19TZXBhcmF0b3IiO30=[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="no" first="yes" size="4"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="no" first="no" size="4"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="4"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YToxMDp7czoxNjoiY3NzX2JvcmRlcl9jb2xvciI7czoxNzoicmdiKDk2LCAxMjAsIDEzOSkiO3M6NjoiaGVpZ2h0IjtzOjI6IjQwIjtzOjU6InN0eWxlIjtzOjk6ImludmlzaWJsZSI7czo5OiJjc3NfcmVzX3QiO3M6NzoiZW5hYmxlZCI7czoxMjoicmVzX3RfaGVpZ2h0IjtzOjI6IjIwIjtzOjk6ImNzc19yZXNfcCI7czo3OiJlbmFibGVkIjtzOjEyOiJyZXNfcF9oZWlnaHQiO3M6MjoiMTUiO3M6MTg6Im1vZHVsZV9pbnN0YW5jZV9pZCI7aTo2MjU0O3M6NzoicG9zdF9pZCI7czo0OiIxMjYzIjtzOjk6Im1vZHVsZV9pZCI7czoxNDoiRFNMQ19TZXBhcmF0b3IiO30=[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="no" first="yes" size="6"] 
[dslc_module]YToyOTp7czoxMToiYnV0dG9uX3RleHQiO3M6MjE6IkZyZWUgU0VPIENvbnN1bHRhdGlvbiI7czo5OiJjc3NfYWxpZ24iO3M6NToicmlnaHQiO3M6MTI6ImNzc19iZ19jb2xvciI7czoxNzoicmdiKDQyLCAxNjAsIDIzOSkiO3M6MTY6ImNzc19ib3JkZXJfY29sb3IiO3M6MjU6InJnYmEoMTI1LCAxOTksIDI1MCwgMC4zNSkiO3M6MjI6ImNzc19ib3JkZXJfY29sb3JfaG92ZXIiO3M6MDoiIjtzOjE2OiJjc3NfYm9yZGVyX3dpZHRoIjtzOjE6IjAiO3M6MTc6ImNzc19tYXJnaW5fYm90dG9tIjtzOjE6IjAiO3M6MjA6ImNzc19wYWRkaW5nX3ZlcnRpY2FsIjtzOjI6IjE2IjtzOjIyOiJjc3NfcGFkZGluZ19ob3Jpem9udGFsIjtzOjI6IjI0IjtzOjE2OiJjc3NfYnV0dG9uX2NvbG9yIjtzOjE4OiJyZ2IoMjU1LCAyNTUsIDI1NSkiO3M6MjI6ImNzc19idXR0b25fY29sb3JfaG92ZXIiO3M6NzoiI2ZmZmZmZiI7czoyMDoiY3NzX2J1dHRvbl9mb250X3NpemUiO3M6MjoiMjMiO3M6MjI6ImNzc19idXR0b25fZm9udF9mYW1pbHkiO3M6NjoiUm9ib3RvIjtzOjE0OiJidXR0b25faWNvbl9pZCI7czoxMDoiZXh0LWJ1YmJsZSI7czoyMzoiY3NzX3Jlc190X21hcmdpbl9ib3R0b20iO3M6MToiMCI7czoyNjoiY3NzX3Jlc190X3BhZGRpbmdfdmVydGljYWwiO3M6MjoiMTIiO3M6Mjg6ImNzc19yZXNfdF9wYWRkaW5nX2hvcml6b250YWwiO3M6MjoiMTIiO3M6MjY6ImNzc19yZXNfdF9idXR0b25fZm9udF9zaXplIjtzOjI6IjExIjtzOjIxOiJjc3NfcmVzX3RfaWNvbl9tYXJnaW4iO3M6MToiNSI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czoyMzoiY3NzX3Jlc19wX21hcmdpbl9ib3R0b20iO3M6MjoiMjAiO3M6MjY6ImNzc19yZXNfcF9wYWRkaW5nX3ZlcnRpY2FsIjtzOjI6IjE4IjtzOjI4OiJjc3NfcmVzX3BfcGFkZGluZ19ob3Jpem9udGFsIjtzOjI6IjI1IjtzOjI2OiJjc3NfcmVzX3BfYnV0dG9uX2ZvbnRfc2l6ZSI7czoyOiIxOCI7czoyMToiY3NzX3Jlc19wX2ljb25fbWFyZ2luIjtzOjE6IjUiO3M6MTY6ImNzc19yZXNfcGhfYWxpZ24iO3M6NjoiY2VudGVyIjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6NjI1NTtzOjc6InBvc3RfaWQiO3M6NDoiMTI2MyI7czo5OiJtb2R1bGVfaWQiO3M6MTE6IkRTTENfQnV0dG9uIjt9[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="6"] 
[dslc_module]YToyODp7czoxMToiYnV0dG9uX3RleHQiO3M6MjA6IlJlcXVlc3QgYSBGcmVlIFF1b3RlIjtzOjEyOiJjc3NfYmdfY29sb3IiO3M6MTY6InJnYigyNTUsIDE2NSwgMCkiO3M6MTg6ImNzc19iZ19jb2xvcl9ob3ZlciI7czoxNjoicmdiKDI1NSwgMTEwLCAwKSI7czoxNjoiY3NzX2JvcmRlcl9jb2xvciI7czoyNDoicmdiYSgyNDMsIDE4MSwgNjgsIDAuMjcpIjtzOjIyOiJjc3NfYm9yZGVyX2NvbG9yX2hvdmVyIjtzOjA6IiI7czoxNjoiY3NzX2JvcmRlcl93aWR0aCI7czoxOiIwIjtzOjE3OiJjc3NfbWFyZ2luX2JvdHRvbSI7czoxOiIwIjtzOjIwOiJjc3NfcGFkZGluZ192ZXJ0aWNhbCI7czoyOiIxNiI7czoyMjoiY3NzX3BhZGRpbmdfaG9yaXpvbnRhbCI7czoyOiIyNCI7czoxNjoiY3NzX2J1dHRvbl9jb2xvciI7czoxODoicmdiKDI1NSwgMjU1LCAyNTUpIjtzOjIyOiJjc3NfYnV0dG9uX2NvbG9yX2hvdmVyIjtzOjc6IiNmZmZmZmYiO3M6MjA6ImNzc19idXR0b25fZm9udF9zaXplIjtzOjI6IjIzIjtzOjIyOiJjc3NfYnV0dG9uX2ZvbnRfZmFtaWx5IjtzOjY6IlJvYm90byI7czoxNDoiYnV0dG9uX2ljb25faWQiO3M6MTI6ImV4dC1iYW5rbm90ZSI7czoyMzoiY3NzX3Jlc190X21hcmdpbl9ib3R0b20iO3M6MjoiMzAiO3M6MjY6ImNzc19yZXNfdF9wYWRkaW5nX3ZlcnRpY2FsIjtzOjI6IjE2IjtzOjI4OiJjc3NfcmVzX3RfcGFkZGluZ19ob3Jpem9udGFsIjtzOjI6IjI0IjtzOjI2OiJjc3NfcmVzX3RfYnV0dG9uX2ZvbnRfc2l6ZSI7czoyOiIyMiI7czoyMToiY3NzX3Jlc190X2ljb25fbWFyZ2luIjtzOjI6IjEwIjtzOjk6ImNzc19yZXNfcCI7czo3OiJlbmFibGVkIjtzOjI2OiJjc3NfcmVzX3BfcGFkZGluZ192ZXJ0aWNhbCI7czoyOiIxOCI7czoyODoiY3NzX3Jlc19wX3BhZGRpbmdfaG9yaXpvbnRhbCI7czoyOiIyOSI7czoyNjoiY3NzX3Jlc19wX2J1dHRvbl9mb250X3NpemUiO3M6MjoiMTgiO3M6MjE6ImNzc19yZXNfcF9pY29uX21hcmdpbiI7czoxOiI1IjtzOjE2OiJjc3NfcmVzX3BoX2FsaWduIjtzOjY6ImNlbnRlciI7czoxODoibW9kdWxlX2luc3RhbmNlX2lkIjtpOjYyNTY7czo3OiJwb3N0X2lkIjtzOjQ6IjEyNjMiO3M6OToibW9kdWxlX2lkIjtzOjExOiJEU0xDX0J1dHRvbiI7fQ==[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo5OntzOjY6ImhlaWdodCI7czoyOiI0MCI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6OToiY3NzX3Jlc190IjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc190X2hlaWdodCI7czoyOiIyMCI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czoxMjoicmVzX3BfaGVpZ2h0IjtzOjI6IjIwIjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6NjI1NztzOjc6InBvc3RfaWQiO3M6NDoiMTI2MyI7czo5OiJtb2R1bGVfaWQiO3M6MTQ6IkRTTENfU2VwYXJhdG9yIjt9[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
[dslc_modules_section type="wrapped" columns_spacing="spacing" border_color="rgb(228, 228, 228)" border_width="1" border_style="solid" border="" bg_color="" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="0" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo5OntzOjY6ImhlaWdodCI7czoyOiI0MCI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6OToiY3NzX3Jlc190IjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc190X2hlaWdodCI7czoyOiIyMCI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czoxMjoicmVzX3BfaGVpZ2h0IjtzOjI6IjIwIjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6NjE3MTtzOjc6InBvc3RfaWQiO3M6NDoiMTI2MyI7czo5OiJtb2R1bGVfaWQiO3M6MTQ6IkRTTENfU2VwYXJhdG9yIjt9[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo1NTp7czo3OiJjb250ZW50IjtzOjI5NToiPGgyPldlIGhhdmUgYSBzdHJhdGVneSBhbmQgZXhwZXJpZW5jZcKgPC9oMj48cD5PdXIgc2VhcmNoIHRlYW0gYXJlIHNwZWNpYWxpc3RzIGluIGJvdGggb24tcGFnZSBhbmQgb2ZmLXBhZ2UgU0VPIGFzIHdlbGwgYXMgUFBDLiBXZSBoYXZlIGEgcHJvdmVuIHRyYWNrIHJlY29yZCBpbiBpbmNyZWFzaW5nIHNlYXJjaCBlbmdpbmUgcmFua2luZ3MgZm9yIG91ciBjbGllbnRzLiBPdXIgc3RyYXRlZ2llcyBhcmUgZGVzaWduZWQgdG8gYWNoaWV2ZSBvbmUgb3IgbW9yZSBvZiB0aGUgZm9sbG93aW5nIHRocmVlIGFpbXMuPC9wPiI7czoxNzoiY3NzX21hcmdpbl9ib3R0b20iO3M6MzoiMTAwIjtzOjI3OiJjc3NfbWFpbl9wYWRkaW5nX2hvcml6b250YWwiO3M6MjoiNDUiO3M6MTg6ImNzc19tYWluX2ZvbnRfc2l6ZSI7czoyOiIyMCI7czoyMDoiY3NzX21haW5fZm9udF93ZWlnaHQiO3M6MzoiMzAwIjtzOjIwOiJjc3NfbWFpbl9mb250X2ZhbWlseSI7czo2OiJSb2JvdG8iO3M6MjA6ImNzc19tYWluX2xpbmVfaGVpZ2h0IjtzOjI6IjMwIjtzOjE5OiJjc3NfbWFpbl90ZXh0X2FsaWduIjtzOjY6ImNlbnRlciI7czoxNjoiY3NzX2gxX2ZvbnRfc2l6ZSI7czoxOiIwIjtzOjE4OiJjc3NfaDFfZm9udF93ZWlnaHQiO3M6MzoiNDAwIjtzOjE4OiJjc3NfaDFfZm9udF9mYW1pbHkiO3M6OToiT3BlbiBTYW5zIjtzOjE4OiJjc3NfaDFfbGluZV9oZWlnaHQiO3M6MjoiMjIiO3M6MjA6ImNzc19oMV9tYXJnaW5fYm90dG9tIjtzOjI6IjE1IjtzOjE2OiJjc3NfaDJfZm9udF9zaXplIjtzOjI6IjQ1IjtzOjE4OiJjc3NfaDJfZm9udF93ZWlnaHQiO3M6MzoiMjAwIjtzOjE4OiJjc3NfaDJfZm9udF9mYW1pbHkiO3M6NjoiUm9ib3RvIjtzOjE4OiJjc3NfaDJfbGluZV9oZWlnaHQiO3M6MjoiNTIiO3M6MjA6ImNzc19oMl9tYXJnaW5fYm90dG9tIjtzOjI6IjMwIjtzOjE3OiJjc3NfaDJfdGV4dF9hbGlnbiI7czo2OiJjZW50ZXIiO3M6MTY6ImNzc19oM19mb250X3NpemUiO3M6MjoiMzYiO3M6MTg6ImNzc19oM19mb250X3dlaWdodCI7czozOiIyMDAiO3M6MTg6ImNzc19oM19mb250X2ZhbWlseSI7czo2OiJSb2JvdG8iO3M6MTg6ImNzc19oM19saW5lX2hlaWdodCI7czoyOiI0NCI7czoyMDoiY3NzX2gzX21hcmdpbl9ib3R0b20iO3M6MjoiMjQiO3M6MTY6ImNzc19oNF9mb250X3NpemUiO3M6MjoiMTMiO3M6MTg6ImNzc19oNF9mb250X3dlaWdodCI7czozOiI0MDAiO3M6MTg6ImNzc19oNF9mb250X2ZhbWlseSI7czo5OiJPcGVuIFNhbnMiO3M6MTg6ImNzc19oNF9saW5lX2hlaWdodCI7czoyOiIyMiI7czoyMDoiY3NzX2g0X21hcmdpbl9ib3R0b20iO3M6MjoiMTUiO3M6MTY6ImNzc19oNV9mb250X3NpemUiO3M6MjoiMTMiO3M6MTg6ImNzc19oNV9mb250X3dlaWdodCI7czozOiI0MDAiO3M6MTg6ImNzc19oNV9mb250X2ZhbWlseSI7czo5OiJPcGVuIFNhbnMiO3M6MTg6ImNzc19oNV9saW5lX2hlaWdodCI7czoyOiIyMiI7czoyMDoiY3NzX2g1X21hcmdpbl9ib3R0b20iO3M6MjoiMTUiO3M6MTY6ImNzc19oNl9mb250X3NpemUiO3M6MjoiMTMiO3M6MTg6ImNzc19oNl9mb250X3dlaWdodCI7czozOiI0MDAiO3M6MTg6ImNzc19oNl9mb250X2ZhbWlseSI7czo5OiJPcGVuIFNhbnMiO3M6MTg6ImNzc19oNl9saW5lX2hlaWdodCI7czoyOiIyMiI7czoyMDoiY3NzX2g2X21hcmdpbl9ib3R0b20iO3M6MjoiMTUiO3M6OToiY3NzX3Jlc190IjtzOjc6ImVuYWJsZWQiO3M6MjM6ImNzc19yZXNfdF9tYXJnaW5fYm90dG9tIjtzOjI6IjUwIjtzOjI0OiJjc3NfcmVzX3RfbWFpbl9mb250X3NpemUiO3M6MjoiMTgiO3M6MjY6ImNzc19yZXNfdF9tYWluX2xpbmVfaGVpZ2h0IjtzOjI6IjI1IjtzOjIyOiJjc3NfcmVzX3RfaDJfZm9udF9zaXplIjtzOjI6IjM3IjtzOjI0OiJjc3NfcmVzX3RfaDJfbGluZV9oZWlnaHQiO3M6MjoiNDAiO3M6MjY6ImNzc19yZXNfdF9oMl9tYXJnaW5fYm90dG9tIjtzOjI6IjIwIjtzOjk6ImNzc19yZXNfcCI7czo3OiJlbmFibGVkIjtzOjI0OiJjc3NfcmVzX3BoX21hcmdpbl9ib3R0b20iO3M6MjoiNDAiO3M6MjU6ImNzc19yZXNfcGhfbWFpbl9mb250X3NpemUiO3M6MjoiMTYiO3M6Mjc6ImNzc19yZXNfcGhfbWFpbl9saW5lX2hlaWdodCI7czoyOiIyNCI7czoyMzoiY3NzX3Jlc19waF9oMl9mb250X3NpemUiO3M6MjoiMzAiO3M6MjU6ImNzc19yZXNfcGhfaDJfbGluZV9oZWlnaHQiO3M6MjoiMzUiO3M6MTg6Im1vZHVsZV9pbnN0YW5jZV9pZCI7aTo2MTcyO3M6NzoicG9zdF9pZCI7czo0OiIxMjYzIjtzOjk6Im1vZHVsZV9pZCI7czoxNjoiRFNMQ19UZXh0X1NpbXBsZSI7fQ==[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="no" first="yes" size="4"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="no" first="no" size="4"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="4"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo5OntzOjE2OiJjc3NfYm9yZGVyX2NvbG9yIjtzOjE4OiJyZ2IoMjQ4LCAyNDgsIDI0OCkiO3M6NjoiaGVpZ2h0IjtzOjI6IjU0IjtzOjk6ImNzc19yZXNfdCI7czo3OiJlbmFibGVkIjtzOjEyOiJyZXNfdF9oZWlnaHQiO3M6MjoiMjQiO3M6OToiY3NzX3Jlc19wIjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc19wX2hlaWdodCI7czoyOiIyMCI7czoxODoibW9kdWxlX2luc3RhbmNlX2lkIjtpOjYxNzY7czo3OiJwb3N0X2lkIjtzOjQ6IjEyNjMiO3M6OToibW9kdWxlX2lkIjtzOjE0OiJEU0xDX1NlcGFyYXRvciI7fQ==[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="no" first="yes" size="6"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="6"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo5OntzOjY6ImhlaWdodCI7czoyOiI0MCI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6OToiY3NzX3Jlc190IjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc190X2hlaWdodCI7czoyOiIyMCI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czoxMjoicmVzX3BfaGVpZ2h0IjtzOjI6IjIwIjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6NjE3OTtzOjc6InBvc3RfaWQiO3M6NDoiMTI2MyI7czo5OiJtb2R1bGVfaWQiO3M6MTQ6IkRTTENfU2VwYXJhdG9yIjt9[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
[dslc_modules_section type="wrapped" columns_spacing="spacing" border_color="" border_width="0" border_style="solid" border="top bottom" bg_color="rgb(89, 172, 231)" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="0" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo4OntzOjU6InN0eWxlIjtzOjk6ImludmlzaWJsZSI7czo5OiJjc3NfcmVzX3QiO3M6NzoiZW5hYmxlZCI7czoxMjoicmVzX3RfaGVpZ2h0IjtzOjI6IjIwIjtzOjk6ImNzc19yZXNfcCI7czo3OiJlbmFibGVkIjtzOjEyOiJyZXNfcF9oZWlnaHQiO3M6MjoiMTUiO3M6MTg6Im1vZHVsZV9pbnN0YW5jZV9pZCI7aTo2Mjc3O3M6NzoicG9zdF9pZCI7czo0OiIxMjYzIjtzOjk6Im1vZHVsZV9pZCI7czoxNDoiRFNMQ19TZXBhcmF0b3IiO30=[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo4ODp7czo1OiJvcmRlciI7czo0OiJERVNDIjtzOjg6ImVsZW1lbnRzIjtzOjEzOiJtYWluX2hlYWRpbmcgIjtzOjEzOiJwb3N0X2VsZW1lbnRzIjtzOjI3OiJxdW90ZSBhdmF0YXIgbmFtZSBwb3NpdGlvbiAiO3M6MTc6ImNhcm91c2VsX2VsZW1lbnRzIjtzOjE1OiJhcnJvd3MgY2lyY2xlcyAiO3M6MTQ6ImNzc19zZXBfaGVpZ2h0IjtzOjE6IjAiO3M6MjE6ImNzc19xdW90ZV9ib3JkZXJfdHJibCI7czowOiIiO3M6MTU6ImNzc19xdW90ZV9jb2xvciI7czoxODoicmdiKDI1NSwgMjU1LCAyNTUpIjtzOjE5OiJjc3NfcXVvdGVfZm9udF9zaXplIjtzOjI6IjI3IjtzOjIxOiJjc3NfcXVvdGVfZm9udF9mYW1pbHkiO3M6NjoiUm9ib3RvIjtzOjIxOiJjc3NfcXVvdGVfbGluZV9oZWlnaHQiO3M6MjoiNDAiO3M6MjE6ImNzc19xdW90ZV9wYWRkaW5nX3RvcCI7czoyOiIxOCI7czoyMToiY3NzX2F1dGhvcl9tYXJnaW5fdG9wIjtzOjI6IjE2IjtzOjE5OiJjc3NfYXZhdGFyX2JnX2NvbG9yIjtzOjIxOiJyZ2JhKDI0LCAyNCwgMjUsIDAuMSkiO3M6MjM6ImNzc19hdmF0YXJfYm9yZGVyX2NvbG9yIjtzOjE5OiJyZ2JhKDAsIDAsIDAsIDAuMTMpIjtzOjE0OiJjc3NfbmFtZV9jb2xvciI7czoxODoicmdiKDI1MSwgMjUxLCAyNTUpIjtzOjIwOiJjc3NfbmFtZV9mb250X2ZhbWlseSI7czo2OiJSb2JvdG8iO3M6MTg6ImNzc19wb3NpdGlvbl9jb2xvciI7czoyNToicmdiYSgyNTUsIDI1NSwgMjU1LCAwLjQ5KSI7czoyNDoiY3NzX3Bvc2l0aW9uX2ZvbnRfZmFtaWx5IjtzOjY6IlJvYm90byI7czo5OiJjc3NfcmVzX3QiO3M6NzoiZW5hYmxlZCI7czozMToiY3NzX3Jlc190X21haW5fcGFkZGluZ192ZXJ0aWNhbCI7czoxOiIwIjtzOjMzOiJjc3NfcmVzX3RfbWFpbl9wYWRkaW5nX2hvcml6b250YWwiO3M6MToiMCI7czoyNToiY3NzX3Jlc190X3F1b3RlX2ZvbnRfc2l6ZSI7czoyOiIyMSI7czoyMjoiY3NzX3Jlc190X3F1b3RlX21hcmdpbiI7czoxOiIwIjtzOjMwOiJjc3NfcmVzX3RfcXVvdGVfcGFkZGluZ19ib3R0b20iO3M6MToiMCI7czoyODoiY3NzX3Jlc190X2F1dGhvcl9tYXJnaW5fbGVmdCI7czoyOiIxOSI7czoyOToiY3NzX3Jlc190X2F1dGhvcl9tYXJnaW5fcmlnaHQiO3M6MToiMiI7czoyMToiY3NzX3Jlc190X2F2YXRhcl9zaXplIjtzOjI6IjYyIjtzOjI0OiJjc3NfcmVzX3RfbmFtZV9mb250X3NpemUiO3M6MjoiMjMiO3M6MjU6ImNzc19yZXNfdF9uYW1lX21hcmdpbl90b3AiO3M6MToiNSI7czoyODoiY3NzX3Jlc190X3Bvc2l0aW9uX2ZvbnRfc2l6ZSI7czoyOiIxNCI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czoyMzoiY3NzX3Jlc19wX21hcmdpbl9ib3R0b20iO3M6MjoiMTAiO3M6MjA6ImNzc19yZXNfcF9zZXBfaGVpZ2h0IjtzOjI6IjMxIjtzOjMzOiJjc3NfcmVzX3BfbWFpbl9wYWRkaW5nX2hvcml6b250YWwiO3M6MToiMyI7czozMDoiY3NzX3Jlc19wX3F1b3RlX3BhZGRpbmdfYm90dG9tIjtzOjE6IjAiO3M6MzA6ImNzc19yZXNfcF9hdXRob3JfbWFyZ2luX2JvdHRvbSI7czoyOiIyMCI7czoyODoiY3NzX3Jlc19wX2F1dGhvcl9tYXJnaW5fbGVmdCI7czoxOiIzIjtzOjE4OiJtYWluX2hlYWRpbmdfdGl0bGUiO3M6MjE6IkhvdyBvdXIgY29tcGFueSBoZWxwcyI7czoyMzoibWFpbl9oZWFkaW5nX2xpbmtfdGl0bGUiO3M6MjA6IlNlZSBhbGwgdGVzdGltb25pYWxzIjtzOjIyOiJjc3NfbWFpbl9oZWFkaW5nX2NvbG9yIjtzOjE3OiJyZ2IoMzcsIDEwMSwgMTQ2KSI7czoyNjoiY3NzX21haW5faGVhZGluZ19mb250X3NpemUiO3M6MjoiMjQiO3M6Mjg6ImNzc19tYWluX2hlYWRpbmdfZm9udF9mYW1pbHkiO3M6NjoiUm9ib3RvIjtzOjI4OiJjc3NfbWFpbl9oZWFkaW5nX2xpbmVfaGVpZ2h0IjtzOjI6IjM3IjtzOjI3OiJjc3NfbWFpbl9oZWFkaW5nX2xpbmtfY29sb3IiO3M6MTg6InJnYigyNTUsIDI1NSwgMjU1KSI7czozMToiY3NzX21haW5faGVhZGluZ19saW5rX2ZvbnRfc2l6ZSI7czoyOiIxOCI7czozMzoiY3NzX21haW5faGVhZGluZ19saW5rX2ZvbnRfZmFtaWx5IjtzOjY6IlJvYm90byI7czozMzoiY3NzX21haW5faGVhZGluZ19saW5rX3BhZGRpbmdfdmVyIjtzOjE6IjgiO3M6MjY6ImNzc19tYWluX2hlYWRpbmdfc2VwX2NvbG9yIjtzOjE3OiJyZ2IoNTksIDEzNSwgMTg3KSI7czoyNToiY3NzX2hlYWRpbmdfbWFyZ2luX2JvdHRvbSI7czoyOiI0MCI7czozMjoiY3NzX3Jlc190X21haW5faGVhZGluZ19mb250X3NpemUiO3M6MjoiMjMiO3M6MzQ6ImNzc19yZXNfdF9tYWluX2hlYWRpbmdfbGluZV9oZWlnaHQiO3M6MjoiMzYiO3M6Mzc6ImNzc19yZXNfdF9tYWluX2hlYWRpbmdfbGlua19mb250X3NpemUiO3M6MjoiMTYiO3M6MzE6ImNzc19yZXNfdF9oZWFkaW5nX21hcmdpbl9ib3R0b20iO3M6MjoiMzAiO3M6Mzk6ImNzc19yZXNfcF9tYWluX2hlYWRpbmdfbGlua19wYWRkaW5nX3ZlciI7czoyOiIxMCI7czozMToiY3NzX3Jlc19wX2hlYWRpbmdfbWFyZ2luX2JvdHRvbSI7czoyOiIxMCI7czoyMzoiY3NzX2ZpbHRlcl9ib3JkZXJfY29sb3IiO3M6NzoiI2U4ZThlOCI7czoyMDoiY3NzX2ZpbHRlcl9mb250X3NpemUiO3M6MjoiMTEiO3M6MjI6ImNzc19maWx0ZXJfZm9udF93ZWlnaHQiO3M6MzoiNzAwIjtzOjIyOiJjc3NfZmlsdGVyX2ZvbnRfZmFtaWx5IjtzOjk6Ik9wZW4gU2FucyI7czoyOToiY3NzX2ZpbHRlcl9wYWRkaW5nX2hvcml6b250YWwiO3M6MjoiMTIiO3M6MTk6ImNzc19maWx0ZXJfcG9zaXRpb24iO3M6NDoibGVmdCI7czoyNDoiY3NzX2ZpbHRlcl9tYXJnaW5fYm90dG9tIjtzOjI6IjIwIjtzOjI2OiJjc3NfcmVzX3BfZmlsdGVyX2ZvbnRfc2l6ZSI7czoyOiIyNyI7czozMzoiY3NzX3Jlc19wX2ZpbHRlcl9wYWRkaW5nX3ZlcnRpY2FsIjtzOjI6IjE2IjtzOjM1OiJjc3NfcmVzX3BfZmlsdGVyX3BhZGRpbmdfaG9yaXpvbnRhbCI7czoyOiIzMSI7czoyNDoiY3NzX3Jlc19wX2ZpbHRlcl9zcGFjaW5nIjtzOjI6IjQ5IjtzOjMwOiJjc3NfcmVzX3BfZmlsdGVyX21hcmdpbl9ib3R0b20iO3M6MjoiMTAiO3M6MjM6ImNzc19hcnJvd3NfYm9yZGVyX2NvbG9yIjtzOjE4OiJyZ2IoMTQxLCAxOTgsIDIzOSkiO3M6MTY6ImNzc19hcnJvd3NfY29sb3IiO3M6MTg6InJnYigxOTEsIDIyNSwgMjUwKSI7czoyMToiY3NzX2Fycm93c19tYXJnaW5fdG9wIjtzOjE6IjAiO3M6MTU6ImNzc19hcnJvd3Nfc2l6ZSI7czoyOiI0MSI7czoyNDoiY3NzX2Fycm93c19tYXJnaW5fYm90dG9tIjtzOjI6IjEwIjtzOjE3OiJjc3NfY2lyY2xlc19jb2xvciI7czoxNzoicmdiKDc4LCAxNTYsIDIxMikiO3M6MjQ6ImNzc19jaXJjbGVzX2NvbG9yX2FjdGl2ZSI7czoxODoicmdiKDI1NSwgMjU1LCAyNTUpIjtzOjE2OiJjc3NfY2lyY2xlc19zaXplIjtzOjE6IjciO3M6MTk6ImNzc19jaXJjbGVzX3NwYWNpbmciO3M6MToiNiI7czoxMzoiY3NzX3BhZ19hbGlnbiI7czo0OiJsZWZ0IjtzOjIwOiJjc3NfcGFnX2JvcmRlcl9jb2xvciI7czowOiIiO3M6MjI6ImNzc19wYWdfaXRlbV9mb250X3NpemUiO3M6MjoiMTEiO3M6MjQ6ImNzc19wYWdfaXRlbV9mb250X3dlaWdodCI7czozOiI3MDAiO3M6MjQ6ImNzc19wYWdfaXRlbV9mb250X2ZhbWlseSI7czo5OiJPcGVuIFNhbnMiO3M6Mjk6ImNzc19wYWdfaXRlbV9wYWRkaW5nX3ZlcnRpY2FsIjtzOjI6IjEyIjtzOjMxOiJjc3NfcGFnX2l0ZW1fcGFkZGluZ19ob3Jpem9udGFsIjtzOjI6IjEyIjtzOjIwOiJjc3NfcGFnX2l0ZW1fc3BhY2luZyI7czoyOiIxMCI7czoxODoibW9kdWxlX2luc3RhbmNlX2lkIjtpOjYyNzg7czo3OiJwb3N0X2lkIjtzOjQ6IjEyNjMiO3M6MTQ6ImV4Y2VycHRfbGVuZ3RoIjtpOjIwO3M6OToibW9kdWxlX2lkIjtzOjE3OiJEU0xDX1Rlc3RpbW9uaWFscyI7fQ==[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo4OntzOjU6InN0eWxlIjtzOjk6ImludmlzaWJsZSI7czo5OiJjc3NfcmVzX3QiO3M6NzoiZW5hYmxlZCI7czoxMjoicmVzX3RfaGVpZ2h0IjtzOjI6IjIwIjtzOjk6ImNzc19yZXNfcCI7czo3OiJlbmFibGVkIjtzOjEyOiJyZXNfcF9oZWlnaHQiO3M6MjoiMTUiO3M6MTg6Im1vZHVsZV9pbnN0YW5jZV9pZCI7aTo2Mjc5O3M6NzoicG9zdF9pZCI7czo0OiIxMjYzIjtzOjk6Im1vZHVsZV9pZCI7czoxNDoiRFNMQ19TZXBhcmF0b3IiO30=[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
[dslc_modules_section type="wrapped" columns_spacing="spacing" border_color="" border_width="0" border_style="solid" border="rgb(51, 66, 71)" bg_color="rgb(33, 51, 65)" bg_image_thumb="disabled" bg_image="428" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="0" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo5OntzOjY6ImhlaWdodCI7czoyOiI0MCI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6OToiY3NzX3Jlc190IjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc190X2hlaWdodCI7czoyOiIyMCI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czoxMjoicmVzX3BfaGVpZ2h0IjtzOjI6IjIwIjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6Njk2NDtzOjc6InBvc3RfaWQiO3M6NDoiMTI2NiI7czo5OiJtb2R1bGVfaWQiO3M6MTQ6IkRTTENfU2VwYXJhdG9yIjt9[/dslc_module] 
[dslc_module]YToyMzp7czo2OiJhbW91bnQiO3M6MToiNCI7czo4OiJlbGVtZW50cyI7czoxMzoibWFpbl9oZWFkaW5nICI7czoxMzoicG9zdF9lbGVtZW50cyI7czoyNDoidGh1bWJuYWlsIHRpdGxlIGV4Y2VycHQgIjtzOjE3OiJjYXJvdXNlbF9lbGVtZW50cyI7czoxNToiYXJyb3dzIGNpcmNsZXMgIjtzOjE4OiJ0aHVtYl9yZXNpemVfd2lkdGgiO3M6MzoiMzgzIjtzOjE5OiJjc3NfbWFpbl9taW5faGVpZ2h0IjtzOjM6IjE3MSI7czoyMToiY3NzX2V4Y2VycHRfZm9udF9zaXplIjtzOjI6IjE0IjtzOjE0OiJleGNlcnB0X21hcmdpbiI7czoxOiIwIjtzOjE0OiJleGNlcnB0X2xlbmd0aCI7czoyOiIxNCI7czo5OiJjc3NfcmVzX3QiO3M6NzoiZW5hYmxlZCI7czozMzoiY3NzX3Jlc190X21haW5fcGFkZGluZ19ob3Jpem9udGFsIjtzOjI6IjIwIjtzOjI3OiJjc3NfcmVzX3RfZXhjZXJwdF9mb250X3NpemUiO3M6MjoiMTMiO3M6OToiY3NzX3Jlc19wIjtzOjc6ImVuYWJsZWQiO3M6MjM6ImNzc19yZXNfcF9tYXJnaW5fYm90dG9tIjtzOjI6IjEwIjtzOjE4OiJtYWluX2hlYWRpbmdfdGl0bGUiO3M6MTY6Ik91ciBjYXNlIHN0dWRpZXMiO3M6MjM6Im1haW5faGVhZGluZ19saW5rX3RpdGxlIjtzOjE2OiJTZWUgYWxsIHByb2plY3RzIjtzOjIyOiJjc3NfbWFpbl9oZWFkaW5nX2NvbG9yIjtzOjE4OiJyZ2IoMTc0LCAxODYsIDE5OCkiO3M6Mjc6ImNzc19tYWluX2hlYWRpbmdfbGlua19jb2xvciI7czoxODoicmdiKDI1NSwgMjU1LCAyNTUpIjtzOjI2OiJjc3NfbWFpbl9oZWFkaW5nX3NlcF9jb2xvciI7czoyNToicmdiYSgxNTUsIDE1NSwgMTU1LCAwLjQ4KSI7czozNDoiY3NzX3Jlc190X21haW5faGVhZGluZ19saW5lX2hlaWdodCI7czoyOiIzNiI7czoxODoibW9kdWxlX2luc3RhbmNlX2lkIjtpOjY5NjU7czo3OiJwb3N0X2lkIjtzOjQ6IjEyNjMiO3M6OToibW9kdWxlX2lkIjtzOjEzOiJEU0xDX1Byb2plY3RzIjt9[/dslc_module] 
[dslc_module]YTo5OntzOjY6ImhlaWdodCI7czoyOiI0MCI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6OToiY3NzX3Jlc190IjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc190X2hlaWdodCI7czoyOiIyMCI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czoxMjoicmVzX3BfaGVpZ2h0IjtzOjE6IjEiO3M6MTg6Im1vZHVsZV9pbnN0YW5jZV9pZCI7aTo2OTY2O3M6NzoicG9zdF9pZCI7czo0OiIxMjYzIjtzOjk6Im1vZHVsZV9pZCI7czoxNDoiRFNMQ19TZXBhcmF0b3IiO30=[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
',
			'section' => 'original'
		);

		$dslc_var_templates['dslc-blog'] = array(
			'title' => __( 'Blog', 'dslc_string' ),
			'id' => 'dslc-blog',
			'code' => '[dslc_modules_section type="wrapped" columns_spacing="spacing" border_color="" border_width="0" border_style="solid" border="top bottom" bg_color="rgb(241, 241, 241)" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="0" padding_h="0" margin_h="0" margin_b="0" custom_class="blog-noauthor blog-balanced-thumbnail blog-add-icons" custom_id="" ] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo5OntzOjY6ImhlaWdodCI7czoyOiIzMCI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6OToiY3NzX3Jlc190IjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc190X2hlaWdodCI7czoyOiIxNSI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czoxMjoicmVzX3BfaGVpZ2h0IjtzOjI6IjE1IjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO3M6NDoiMTA1NyI7czo3OiJwb3N0X2lkIjtzOjM6IjgxNiI7czo5OiJtb2R1bGVfaWQiO3M6MTQ6IkRTTENfU2VwYXJhdG9yIjt9[/dslc_module] 
[dslc_module]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[/dslc_module] 
[dslc_module]YTo5OntzOjY6ImhlaWdodCI7czoyOiIxNSI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6OToiY3NzX3Jlc190IjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc190X2hlaWdodCI7czoxOiI1IjtzOjk6ImNzc19yZXNfcCI7czo3OiJlbmFibGVkIjtzOjEyOiJyZXNfcF9oZWlnaHQiO3M6MToiNSI7czoxODoibW9kdWxlX2luc3RhbmNlX2lkIjtzOjQ6IjY5OTAiO3M6NzoicG9zdF9pZCI7czozOiI4MTYiO3M6OToibW9kdWxlX2lkIjtzOjE0OiJEU0xDX1NlcGFyYXRvciI7fQ==[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
',
			'section' => 'original'
		);
		$dslc_var_templates['dslc-contact-us'] = array(
			'title' => __( 'Contact us', 'dslc_string' ),
			'id' => 'dslc-contact-us',
			'code' => '
[dslc_modules_section type="full" columns_spacing="nospacing" border_color="" border_width="0" border_style="solid" border="top bottom" bg_color="transparent" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="0" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo3OntzOjY6ImhlaWdodCI7czoyOiIxNSI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6OToiY3NzX3Jlc190IjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc190X2hlaWdodCI7czoyOiIxNSI7czoxODoibW9kdWxlX2luc3RhbmNlX2lkIjtzOjQ6IjI5NjMiO3M6NzoicG9zdF9pZCI7czozOiI2MjYiO3M6OToibW9kdWxlX2lkIjtzOjE0OiJEU0xDX1NlcGFyYXRvciI7fQ==[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
[dslc_modules_section type="wrapped" columns_spacing="spacing" border_color="" border_width="0" border_style="solid" border="top bottom" bg_color="" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="0" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="no" first="yes" size="4"] 
[dslc_module]YTo1OntzOjY6ImhlaWdodCI7czoxOiIxIjtzOjU6InN0eWxlIjtzOjk6ImludmlzaWJsZSI7czoxODoibW9kdWxlX2luc3RhbmNlX2lkIjtzOjQ6IjEzODAiO3M6NzoicG9zdF9pZCI7czozOiI2MjYiO3M6OToibW9kdWxlX2lkIjtzOjE0OiJEU0xDX1NlcGFyYXRvciI7fQ==[/dslc_module] 
[dslc_module]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[/dslc_module] 
[dslc_module]YToyOTp7czoxMToiYnV0dG9uX3RleHQiO3M6MTY6ImV4YW1wbGVza3lwZW5hbWUiO3M6MTg6ImNzc19iZ19jb2xvcl9ob3ZlciI7czoxMToidHJhbnNwYXJlbnQiO3M6MTY6ImNzc19ib3JkZXJfY29sb3IiO3M6MTg6InJnYigyMzksIDIzNiwgMjM2KSI7czoxNjoiY3NzX2JvcmRlcl93aWR0aCI7czoxOiIwIjtzOjE3OiJjc3NfYm9yZGVyX3JhZGl1cyI7czoxOiIzIjtzOjE3OiJjc3NfbWFyZ2luX2JvdHRvbSI7czoxOiIwIjtzOjIwOiJjc3NfcGFkZGluZ192ZXJ0aWNhbCI7czoxOiI4IjtzOjIyOiJjc3NfcGFkZGluZ19ob3Jpem9udGFsIjtzOjI6IjI1IjtzOjE2OiJjc3NfYnV0dG9uX2NvbG9yIjtzOjE1OiJyZ2IoNjUsIDcyLCA3NykiO3M6MjI6ImNzc19idXR0b25fY29sb3JfaG92ZXIiO3M6MTc6InJnYig3NSwgMTIzLCAxOTQpIjtzOjIwOiJjc3NfYnV0dG9uX2ZvbnRfc2l6ZSI7czoyOiIyMCI7czoxNDoiYnV0dG9uX2ljb25faWQiO3M6OToiZXh0LXNreXBlIjtzOjE0OiJjc3NfaWNvbl9jb2xvciI7czoxODoicmdiKDIyMSwgMjE5LCAyMTkpIjtzOjIwOiJjc3NfaWNvbl9jb2xvcl9ob3ZlciI7czoxNzoicmdiKDc1LCAxMjMsIDE5NCkiO3M6MTU6ImNzc19pY29uX21hcmdpbiI7czoyOiIxMiI7czo5OiJjc3NfcmVzX3QiO3M6NzoiZW5hYmxlZCI7czoyMzoiY3NzX3Jlc190X21hcmdpbl9ib3R0b20iO3M6MToiMCI7czoyNjoiY3NzX3Jlc190X3BhZGRpbmdfdmVydGljYWwiO3M6MToiMCI7czoyODoiY3NzX3Jlc190X3BhZGRpbmdfaG9yaXpvbnRhbCI7czoxOiI0IjtzOjI2OiJjc3NfcmVzX3RfYnV0dG9uX2ZvbnRfc2l6ZSI7czoyOiIxNyI7czoyMToiY3NzX3Jlc190X2ljb25fbWFyZ2luIjtzOjI6IjEzIjtzOjk6ImNzc19yZXNfcCI7czo3OiJlbmFibGVkIjtzOjI2OiJjc3NfcmVzX3BfcGFkZGluZ192ZXJ0aWNhbCI7czoxOiIwIjtzOjI4OiJjc3NfcmVzX3BfcGFkZGluZ19ob3Jpem9udGFsIjtzOjI6IjEyIjtzOjI2OiJjc3NfcmVzX3BfYnV0dG9uX2ZvbnRfc2l6ZSI7czoyOiIyMCI7czoyMToiY3NzX3Jlc19wX2ljb25fbWFyZ2luIjtzOjI6IjIxIjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO3M6NDoiMTM1MiI7czo3OiJwb3N0X2lkIjtzOjM6IjYyNiI7czo5OiJtb2R1bGVfaWQiO3M6MTE6IkRTTENfQnV0dG9uIjt9[/dslc_module] 
[dslc_module]YTozMDp7czoxMToiYnV0dG9uX3RleHQiO3M6MTk6ImluZm9Ac2Vvd3B0aGVtZS5jb20iO3M6MTg6ImNzc19iZ19jb2xvcl9ob3ZlciI7czoxMToidHJhbnNwYXJlbnQiO3M6MTY6ImNzc19ib3JkZXJfY29sb3IiO3M6MTg6InJnYigyMzksIDIzNiwgMjM2KSI7czoxNjoiY3NzX2JvcmRlcl93aWR0aCI7czoxOiIwIjtzOjE3OiJjc3NfYm9yZGVyX3JhZGl1cyI7czoxOiIzIjtzOjE3OiJjc3NfbWFyZ2luX2JvdHRvbSI7czoxOiIwIjtzOjIwOiJjc3NfcGFkZGluZ192ZXJ0aWNhbCI7czoxOiI4IjtzOjIyOiJjc3NfcGFkZGluZ19ob3Jpem9udGFsIjtzOjI6IjI1IjtzOjE2OiJjc3NfYnV0dG9uX2NvbG9yIjtzOjE3OiJyZ2IoODgsIDE3OSwgMjM0KSI7czoyMjoiY3NzX2J1dHRvbl9jb2xvcl9ob3ZlciI7czoxNzoicmdiKDc1LCAxMjMsIDE5NCkiO3M6MjA6ImNzc19idXR0b25fZm9udF9zaXplIjtzOjI6IjIwIjtzOjE0OiJidXR0b25faWNvbl9pZCI7czo5OiJleHQtbWFpbDMiO3M6MTQ6ImNzc19pY29uX2NvbG9yIjtzOjI0OiJyZ2JhKDg4LCAxNzksIDIzNCwgMC40MikiO3M6MjA6ImNzc19pY29uX2NvbG9yX2hvdmVyIjtzOjE3OiJyZ2IoNzUsIDEyMywgMTk0KSI7czoxNToiY3NzX2ljb25fbWFyZ2luIjtzOjI6IjEyIjtzOjk6ImNzc19yZXNfdCI7czo3OiJlbmFibGVkIjtzOjIzOiJjc3NfcmVzX3RfbWFyZ2luX2JvdHRvbSI7czoyOiIzMCI7czoyNjoiY3NzX3Jlc190X3BhZGRpbmdfdmVydGljYWwiO3M6MToiMiI7czoyODoiY3NzX3Jlc190X3BhZGRpbmdfaG9yaXpvbnRhbCI7czoxOiI1IjtzOjI2OiJjc3NfcmVzX3RfYnV0dG9uX2ZvbnRfc2l6ZSI7czoyOiIxNiI7czoyMToiY3NzX3Jlc190X2ljb25fbWFyZ2luIjtzOjI6IjE0IjtzOjk6ImNzc19yZXNfcCI7czo3OiJlbmFibGVkIjtzOjIzOiJjc3NfcmVzX3BfbWFyZ2luX2JvdHRvbSI7czoyOiIyMCI7czoyNjoiY3NzX3Jlc19wX3BhZGRpbmdfdmVydGljYWwiO3M6MjoiMTIiO3M6Mjg6ImNzc19yZXNfcF9wYWRkaW5nX2hvcml6b250YWwiO3M6MjoiMTIiO3M6MjY6ImNzc19yZXNfcF9idXR0b25fZm9udF9zaXplIjtzOjI6IjIwIjtzOjIxOiJjc3NfcmVzX3BfaWNvbl9tYXJnaW4iO3M6MjoiMjIiO3M6MTg6Im1vZHVsZV9pbnN0YW5jZV9pZCI7czo0OiIxMzUzIjtzOjc6InBvc3RfaWQiO3M6MzoiNjI2IjtzOjk6Im1vZHVsZV9pZCI7czoxMToiRFNMQ19CdXR0b24iO30=[/dslc_module] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="8"] 
[dslc_module]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[/dslc_module] 
[dslc_module]YTo4OntzOjE3OiJjc3NfbWFyZ2luX2JvdHRvbSI7czoyOiIyNSI7czo5OiJjc3NfcmVzX3QiO3M6NzoiZW5hYmxlZCI7czoyMzoiY3NzX3Jlc190X21hcmdpbl9ib3R0b20iO3M6MjoiMjAiO3M6OToiY3NzX3Jlc19wIjtzOjc6ImVuYWJsZWQiO3M6MjM6ImNzc19yZXNfcF9tYXJnaW5fYm90dG9tIjtzOjI6IjE2IjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO3M6NDoiMjI3NCI7czo3OiJwb3N0X2lkIjtzOjM6IjYyNiI7czo5OiJtb2R1bGVfaWQiO3M6MTU6IkRTTENfVFBfQ29udGVudCI7fQ==[/dslc_module] [/dslc_modules_area] [/dslc_modules_section]
',
			'section' => 'original'
		);
		$dslc_var_templates['dslc-contact-us-m-a'] = array(
			'title' => __( 'Contact us – Multiply addresses', 'dslc_string' ),
			'id' => 'dslc-contact-us-m-a',
			'code' => '
[dslc_modules_section type="wrapped" columns_spacing="nospacing" border_color="" border_width="0" border_style="solid" border="top bottom" bg_color="rgb(241, 241, 241)" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="0" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo5OntzOjY6ImhlaWdodCI7czoyOiIzMCI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6OToiY3NzX3Jlc190IjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc190X2hlaWdodCI7czoyOiIzNCI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czoxMjoicmVzX3BfaGVpZ2h0IjtzOjI6IjIyIjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO3M6NDoiNjkwNiI7czo3OiJwb3N0X2lkIjtzOjM6IjYyOCI7czo5OiJtb2R1bGVfaWQiO3M6MTQ6IkRTTENfU2VwYXJhdG9yIjt9[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="no" first="yes" size="8"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="4"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo5OntzOjY6ImhlaWdodCI7czoyOiIzMCI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6OToiY3NzX3Jlc190IjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc190X2hlaWdodCI7czoyOiIzNCI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czoxMjoicmVzX3BfaGVpZ2h0IjtzOjI6IjIyIjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO3M6MjoiMzMiO3M6NzoicG9zdF9pZCI7czozOiI2MjgiO3M6OToibW9kdWxlX2lkIjtzOjE0OiJEU0xDX1NlcGFyYXRvciI7fQ==[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
[dslc_modules_section type="wrapped" columns_spacing="nospacing" border_color="rgb(244, 244, 244)" border_width="0" border_style="solid" border="bottom " bg_color="" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="0" padding_h="7" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo5OntzOjY6ImhlaWdodCI7czoyOiIyMiI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6OToiY3NzX3Jlc190IjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc190X2hlaWdodCI7czoyOiIyMiI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czoxMjoicmVzX3BfaGVpZ2h0IjtzOjI6IjIwIjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO3M6NDoiNTU3MSI7czo3OiJwb3N0X2lkIjtzOjM6IjYyOCI7czo5OiJtb2R1bGVfaWQiO3M6MTQ6IkRTTENfU2VwYXJhdG9yIjt9[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="no" first="yes" size="8"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="4"] 
[dslc_module]YToyNTp7czoxMToiYnV0dG9uX3RleHQiO3M6MjA6IlJlcXVlc3QgYSBmcmVlIHF1b3RlIjtzOjk6ImNzc19hbGlnbiI7czo1OiJyaWdodCI7czoxNjoiY3NzX2JvcmRlcl9jb2xvciI7czoxODoicmdiKDIzOSwgMjM2LCAyMzYpIjtzOjE3OiJjc3NfYm9yZGVyX3JhZGl1cyI7czoxOiIzIjtzOjE3OiJjc3NfbWFyZ2luX2JvdHRvbSI7czoxOiIwIjtzOjIwOiJjc3NfcGFkZGluZ192ZXJ0aWNhbCI7czoyOiIxMyI7czoyMjoiY3NzX3BhZGRpbmdfaG9yaXpvbnRhbCI7czoyOiIxMyI7czoyMjoiY3NzX2J1dHRvbl9jb2xvcl9ob3ZlciI7czo3OiIjZmZmZmZmIjtzOjIwOiJjc3NfYnV0dG9uX2ZvbnRfc2l6ZSI7czoyOiIyMyI7czoxNDoiYnV0dG9uX2ljb25faWQiO3M6MTQ6ImV4dC1wYXBlcnBsYW5lIjtzOjk6ImNzc19yZXNfdCI7czo3OiJlbmFibGVkIjtzOjIzOiJjc3NfcmVzX3RfbWFyZ2luX2JvdHRvbSI7czoxOiIwIjtzOjI2OiJjc3NfcmVzX3RfcGFkZGluZ192ZXJ0aWNhbCI7czoyOiIxMSI7czoyODoiY3NzX3Jlc190X3BhZGRpbmdfaG9yaXpvbnRhbCI7czoyOiIxMCI7czoyNjoiY3NzX3Jlc190X2J1dHRvbl9mb250X3NpemUiO3M6MjoiMTYiO3M6MjE6ImNzc19yZXNfdF9pY29uX21hcmdpbiI7czoxOiIyIjtzOjE1OiJjc3NfcmVzX3RfYWxpZ24iO3M6NToicmlnaHQiO3M6OToiY3NzX3Jlc19wIjtzOjc6ImVuYWJsZWQiO3M6MjY6ImNzc19yZXNfcF9wYWRkaW5nX3ZlcnRpY2FsIjtzOjI6IjEyIjtzOjI4OiJjc3NfcmVzX3BfcGFkZGluZ19ob3Jpem9udGFsIjtzOjI6IjEyIjtzOjI2OiJjc3NfcmVzX3BfYnV0dG9uX2ZvbnRfc2l6ZSI7czoyOiIyMCI7czoyMToiY3NzX3Jlc19wX2ljb25fbWFyZ2luIjtzOjE6IjUiO3M6MTg6Im1vZHVsZV9pbnN0YW5jZV9pZCI7czo0OiIxMzYwIjtzOjc6InBvc3RfaWQiO3M6MzoiNjI4IjtzOjk6Im1vZHVsZV9pZCI7czoxMToiRFNMQ19CdXR0b24iO30=[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="12"] 
[dslc_module]YTo5OntzOjY6ImhlaWdodCI7czoyOiIyMiI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6OToiY3NzX3Jlc190IjtzOjc6ImVuYWJsZWQiO3M6MTI6InJlc190X2hlaWdodCI7czoyOiIyMiI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czoxMjoicmVzX3BfaGVpZ2h0IjtzOjI6IjIyIjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO3M6NDoiNTU3NyI7czo3OiJwb3N0X2lkIjtzOjM6IjYyOCI7czo5OiJtb2R1bGVfaWQiO3M6MTQ6IkRTTENfU2VwYXJhdG9yIjt9[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
[dslc_modules_section type="wrapped" columns_spacing="nospacing" border_color="rgb(232, 232, 232)" border_width="1" border_style="solid" border="top " bg_color="" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="45" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="no" first="yes" size="4"] 
[dslc_module]YTo1OntzOjY6ImhlaWdodCI7czoxOiIxIjtzOjU6InN0eWxlIjtzOjk6ImludmlzaWJsZSI7czoxODoibW9kdWxlX2luc3RhbmNlX2lkIjtzOjI6IjYxIjtzOjc6InBvc3RfaWQiO3M6MzoiNjI4IjtzOjk6Im1vZHVsZV9pZCI7czoxNDoiRFNMQ19TZXBhcmF0b3IiO30=[/dslc_module] 
[dslc_module]YToyMDp7czo3OiJjb250ZW50IjtzOjIzOiI8aDI+VW5pdGVkIEtpbmdkb208L2gyPiI7czoyNzoiY3NzX21haW5fcGFkZGluZ19ob3Jpem9udGFsIjtzOjI6IjU3IjtzOjEyOiJjc3NfaDJfY29sb3IiO3M6MTc6InJnYigxNDQsIDE3NywgMjgpIjtzOjE2OiJjc3NfaDJfZm9udF9zaXplIjtzOjI6IjI4IjtzOjIwOiJjc3NfaDJfbWFyZ2luX2JvdHRvbSI7czoyOiIxOSI7czoyMzoiY3NzX2gyX3BhZGRpbmdfdmVydGljYWwiO3M6MToiNCI7czo5OiJjc3NfcmVzX3QiO3M6NzoiZW5hYmxlZCI7czozMzoiY3NzX3Jlc190X21haW5fcGFkZGluZ19ob3Jpem9udGFsIjtzOjI6IjM2IjtzOjI0OiJjc3NfcmVzX3RfbWFpbl9mb250X3NpemUiO3M6MjoiMTciO3M6MjI6ImNzc19yZXNfdF9oMl9mb250X3NpemUiO3M6MjoiMTkiO3M6MjQ6ImNzc19yZXNfdF9oMl9saW5lX2hlaWdodCI7czoxOiIwIjtzOjI2OiJjc3NfcmVzX3RfaDJfbWFyZ2luX2JvdHRvbSI7czoyOiIzMCI7czo5OiJjc3NfcmVzX3AiO3M6NzoiZW5hYmxlZCI7czozNDoiY3NzX3Jlc19waF9tYWluX3BhZGRpbmdfaG9yaXpvbnRhbCI7czoyOiI1OCI7czoyMzoiY3NzX3Jlc19waF9oMl9mb250X3NpemUiO3M6MjoiMjIiO3M6MjU6ImNzc19yZXNfcGhfaDJfbGluZV9oZWlnaHQiO3M6MToiMCI7czoyNjoiY3NzX3Jlc19wX2gyX21hcmdpbl9ib3R0b20iO3M6MjoiMzAiO3M6MTg6Im1vZHVsZV9pbnN0YW5jZV9pZCI7czoyOiI2MiI7czo3OiJwb3N0X2lkIjtzOjM6IjYyOCI7czo5OiJtb2R1bGVfaWQiO3M6MTY6IkRTTENfVGV4dF9TaW1wbGUiO30=[/dslc_module] 
[dslc_module]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[/dslc_module] 
[dslc_module]YToyOTp7czoxMToiYnV0dG9uX3RleHQiO3M6MTY6ImV4YW1wbGVza3lwZW5hbWUiO3M6MTg6ImNzc19iZ19jb2xvcl9ob3ZlciI7czoxMToidHJhbnNwYXJlbnQiO3M6MTY6ImNzc19ib3JkZXJfY29sb3IiO3M6MTg6InJnYigyMzksIDIzNiwgMjM2KSI7czoxNjoiY3NzX2JvcmRlcl93aWR0aCI7czoxOiIwIjtzOjE3OiJjc3NfYm9yZGVyX3JhZGl1cyI7czoxOiIzIjtzOjE3OiJjc3NfbWFyZ2luX2JvdHRvbSI7czoxOiIwIjtzOjIwOiJjc3NfcGFkZGluZ192ZXJ0aWNhbCI7czoxOiI4IjtzOjIyOiJjc3NfcGFkZGluZ19ob3Jpem9udGFsIjtzOjI6IjI1IjtzOjE2OiJjc3NfYnV0dG9uX2NvbG9yIjtzOjE1OiJyZ2IoNjUsIDcyLCA3NykiO3M6MjI6ImNzc19idXR0b25fY29sb3JfaG92ZXIiO3M6MTc6InJnYig3NSwgMTIzLCAxOTQpIjtzOjIwOiJjc3NfYnV0dG9uX2ZvbnRfc2l6ZSI7czoyOiIyMCI7czoxNDoiYnV0dG9uX2ljb25faWQiO3M6OToiZXh0LXNreXBlIjtzOjE0OiJjc3NfaWNvbl9jb2xvciI7czoxODoicmdiKDIyMSwgMjE5LCAyMTkpIjtzOjIwOiJjc3NfaWNvbl9jb2xvcl9ob3ZlciI7czoxNzoicmdiKDc1LCAxMjMsIDE5NCkiO3M6MTU6ImNzc19pY29uX21hcmdpbiI7czoyOiIxMiI7czo5OiJjc3NfcmVzX3QiO3M6NzoiZW5hYmxlZCI7czoyMzoiY3NzX3Jlc190X21hcmdpbl9ib3R0b20iO3M6MToiNSI7czoyNjoiY3NzX3Jlc190X3BhZGRpbmdfdmVydGljYWwiO3M6MToiMCI7czoyODoiY3NzX3Jlc190X3BhZGRpbmdfaG9yaXpvbnRhbCI7czoxOiIzIjtzOjI2OiJjc3NfcmVzX3RfYnV0dG9uX2ZvbnRfc2l6ZSI7czoyOiIxNyI7czoyMToiY3NzX3Jlc190X2ljb25fbWFyZ2luIjtzOjI6IjEzIjtzOjk6ImNzc19yZXNfcCI7czo3OiJlbmFibGVkIjtzOjI2OiJjc3NfcmVzX3BfcGFkZGluZ192ZXJ0aWNhbCI7czoxOiIwIjtzOjI4OiJjc3NfcmVzX3BfcGFkZGluZ19ob3Jpem9udGFsIjtzOjI6IjEyIjtzOjI2OiJjc3NfcmVzX3BfYnV0dG9uX2ZvbnRfc2l6ZSI7czoyOiIyMCI7czoyMToiY3NzX3Jlc19wX2ljb25fbWFyZ2luIjtzOjI6IjIxIjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO3M6MjoiNjQiO3M6NzoicG9zdF9pZCI7czozOiI2MjgiO3M6OToibW9kdWxlX2lkIjtzOjExOiJEU0xDX0J1dHRvbiI7fQ==[/dslc_module] 
[dslc_module]YTozMDp7czoxMToiYnV0dG9uX3RleHQiO3M6MTY6ImluZm9AZXhhbXBsZS5jb20iO3M6MTg6ImNzc19iZ19jb2xvcl9ob3ZlciI7czoxMToidHJhbnNwYXJlbnQiO3M6MTY6ImNzc19ib3JkZXJfY29sb3IiO3M6MTg6InJnYigyMzksIDIzNiwgMjM2KSI7czoxNjoiY3NzX2JvcmRlcl93aWR0aCI7czoxOiIwIjtzOjE3OiJjc3NfYm9yZGVyX3JhZGl1cyI7czoxOiIzIjtzOjE3OiJjc3NfbWFyZ2luX2JvdHRvbSI7czoxOiI5IjtzOjIwOiJjc3NfcGFkZGluZ192ZXJ0aWNhbCI7czoxOiI4IjtzOjIyOiJjc3NfcGFkZGluZ19ob3Jpem9udGFsIjtzOjI6IjI1IjtzOjE2OiJjc3NfYnV0dG9uX2NvbG9yIjtzOjE3OiJyZ2IoODgsIDE3OSwgMjM0KSI7czoyMjoiY3NzX2J1dHRvbl9jb2xvcl9ob3ZlciI7czoxNzoicmdiKDc1LCAxMjMsIDE5NCkiO3M6MjA6ImNzc19idXR0b25fZm9udF9zaXplIjtzOjI6IjIwIjtzOjE0OiJidXR0b25faWNvbl9pZCI7czo5OiJleHQtbWFpbDMiO3M6MTQ6ImNzc19pY29uX2NvbG9yIjtzOjI0OiJyZ2JhKDg4LCAxNzksIDIzNCwgMC40MikiO3M6MjA6ImNzc19pY29uX2NvbG9yX2hvdmVyIjtzOjE3OiJyZ2IoNzUsIDEyMywgMTk0KSI7czoxNToiY3NzX2ljb25fbWFyZ2luIjtzOjI6IjEyIjtzOjk6ImNzc19yZXNfdCI7czo3OiJlbmFibGVkIjtzOjIzOiJjc3NfcmVzX3RfbWFyZ2luX2JvdHRvbSI7czoyOiIyNSI7czoyNjoiY3NzX3Jlc190X3BhZGRpbmdfdmVydGljYWwiO3M6MToiMCI7czoyODoiY3NzX3Jlc190X3BhZGRpbmdfaG9yaXpvbnRhbCI7czoxOiI0IjtzOjI2OiJjc3NfcmVzX3RfYnV0dG9uX2ZvbnRfc2l6ZSI7czoyOiIxNiI7czoyMToiY3NzX3Jlc190X2ljb25fbWFyZ2luIjtzOjI6IjE0IjtzOjk6ImNzc19yZXNfcCI7czo3OiJlbmFibGVkIjtzOjIzOiJjc3NfcmVzX3BfbWFyZ2luX2JvdHRvbSI7czoyOiIyMCI7czoyNjoiY3NzX3Jlc19wX3BhZGRpbmdfdmVydGljYWwiO3M6MjoiMTIiO3M6Mjg6ImNzc19yZXNfcF9wYWRkaW5nX2hvcml6b250YWwiO3M6MjoiMTIiO3M6MjY6ImNzc19yZXNfcF9idXR0b25fZm9udF9zaXplIjtzOjI6IjIwIjtzOjIxOiJjc3NfcmVzX3BfaWNvbl9tYXJnaW4iO3M6MjoiMjIiO3M6MTg6Im1vZHVsZV9pbnN0YW5jZV9pZCI7czoyOiI2NSI7czo3OiJwb3N0X2lkIjtzOjM6IjYyOCI7czo5OiJtb2R1bGVfaWQiO3M6MTE6IkRTTENfQnV0dG9uIjt9[/dslc_module] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="8"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] 
[dslc_modules_section type="wrapped" columns_spacing="nospacing" border_color="rgb(232, 232, 232)" border_width="1" border_style="solid" border="top " bg_color="" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="45" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] 
[dslc_modules_area last="no" first="yes" size="4"] 
[dslc_module]YTo1OntzOjY6ImhlaWdodCI7czoxOiIxIjtzOjU6InN0eWxlIjtzOjk6ImludmlzaWJsZSI7czoxODoibW9kdWxlX2luc3RhbmNlX2lkIjtzOjQ6IjE1NjUiO3M6NzoicG9zdF9pZCI7czozOiI2MjgiO3M6OToibW9kdWxlX2lkIjtzOjE0OiJEU0xDX1NlcGFyYXRvciI7fQ==[/dslc_module] 
[dslc_module]YToyMDp7czo3OiJjb250ZW50IjtzOjE1OiI8aDI+Q2FuYWRhPC9oMj4iO3M6Mjc6ImNzc19tYWluX3BhZGRpbmdfaG9yaXpvbnRhbCI7czoyOiI1NyI7czoxMjoiY3NzX2gyX2NvbG9yIjtzOjE3OiJyZ2IoMTQ0LCAxNzcsIDI4KSI7czoxNjoiY3NzX2gyX2ZvbnRfc2l6ZSI7czoyOiIyOCI7czoyMDoiY3NzX2gyX21hcmdpbl9ib3R0b20iO3M6MjoiMTkiO3M6MjM6ImNzc19oMl9wYWRkaW5nX3ZlcnRpY2FsIjtzOjE6IjQiO3M6OToiY3NzX3Jlc190IjtzOjc6ImVuYWJsZWQiO3M6MzM6ImNzc19yZXNfdF9tYWluX3BhZGRpbmdfaG9yaXpvbnRhbCI7czoyOiIzNiI7czoyNDoiY3NzX3Jlc190X21haW5fZm9udF9zaXplIjtzOjI6IjE3IjtzOjIyOiJjc3NfcmVzX3RfaDJfZm9udF9zaXplIjtzOjI6IjE5IjtzOjI0OiJjc3NfcmVzX3RfaDJfbGluZV9oZWlnaHQiO3M6MToiMCI7czoyNjoiY3NzX3Jlc190X2gyX21hcmdpbl9ib3R0b20iO3M6MjoiMzAiO3M6OToiY3NzX3Jlc19wIjtzOjc6ImVuYWJsZWQiO3M6MzQ6ImNzc19yZXNfcGhfbWFpbl9wYWRkaW5nX2hvcml6b250YWwiO3M6MjoiNTgiO3M6MjM6ImNzc19yZXNfcGhfaDJfZm9udF9zaXplIjtzOjI6IjIyIjtzOjI1OiJjc3NfcmVzX3BoX2gyX2xpbmVfaGVpZ2h0IjtzOjE6IjAiO3M6MjY6ImNzc19yZXNfcF9oMl9tYXJnaW5fYm90dG9tIjtzOjI6IjMwIjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO3M6NDoiMTU2NiI7czo3OiJwb3N0X2lkIjtzOjM6IjYyOCI7czo5OiJtb2R1bGVfaWQiO3M6MTY6IkRTTENfVGV4dF9TaW1wbGUiO30=[/dslc_module] 
[dslc_module]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[/dslc_module] 
[dslc_module]YToyOTp7czoxMToiYnV0dG9uX3RleHQiO3M6MTY6ImV4YW1wbGVza3lwZW5hbWUiO3M6MTg6ImNzc19iZ19jb2xvcl9ob3ZlciI7czoxMToidHJhbnNwYXJlbnQiO3M6MTY6ImNzc19ib3JkZXJfY29sb3IiO3M6MTg6InJnYigyMzksIDIzNiwgMjM2KSI7czoxNjoiY3NzX2JvcmRlcl93aWR0aCI7czoxOiIwIjtzOjE3OiJjc3NfYm9yZGVyX3JhZGl1cyI7czoxOiIzIjtzOjE3OiJjc3NfbWFyZ2luX2JvdHRvbSI7czoxOiIwIjtzOjIwOiJjc3NfcGFkZGluZ192ZXJ0aWNhbCI7czoxOiI4IjtzOjIyOiJjc3NfcGFkZGluZ19ob3Jpem9udGFsIjtzOjI6IjI1IjtzOjE2OiJjc3NfYnV0dG9uX2NvbG9yIjtzOjE1OiJyZ2IoNjUsIDcyLCA3NykiO3M6MjI6ImNzc19idXR0b25fY29sb3JfaG92ZXIiO3M6MTc6InJnYig3NSwgMTIzLCAxOTQpIjtzOjIwOiJjc3NfYnV0dG9uX2ZvbnRfc2l6ZSI7czoyOiIyMCI7czoxNDoiYnV0dG9uX2ljb25faWQiO3M6OToiZXh0LXNreXBlIjtzOjE0OiJjc3NfaWNvbl9jb2xvciI7czoxODoicmdiKDIyMSwgMjE5LCAyMTkpIjtzOjIwOiJjc3NfaWNvbl9jb2xvcl9ob3ZlciI7czoxNzoicmdiKDc1LCAxMjMsIDE5NCkiO3M6MTU6ImNzc19pY29uX21hcmdpbiI7czoyOiIxMiI7czo5OiJjc3NfcmVzX3QiO3M6NzoiZW5hYmxlZCI7czoyMzoiY3NzX3Jlc190X21hcmdpbl9ib3R0b20iO3M6MToiNSI7czoyNjoiY3NzX3Jlc190X3BhZGRpbmdfdmVydGljYWwiO3M6MToiMCI7czoyODoiY3NzX3Jlc190X3BhZGRpbmdfaG9yaXpvbnRhbCI7czoxOiIzIjtzOjI2OiJjc3NfcmVzX3RfYnV0dG9uX2ZvbnRfc2l6ZSI7czoyOiIxNyI7czoyMToiY3NzX3Jlc190X2ljb25fbWFyZ2luIjtzOjI6IjEzIjtzOjk6ImNzc19yZXNfcCI7czo3OiJlbmFibGVkIjtzOjI2OiJjc3NfcmVzX3BfcGFkZGluZ192ZXJ0aWNhbCI7czoxOiIwIjtzOjI4OiJjc3NfcmVzX3BfcGFkZGluZ19ob3Jpem9udGFsIjtzOjI6IjEyIjtzOjI2OiJjc3NfcmVzX3BfYnV0dG9uX2ZvbnRfc2l6ZSI7czoyOiIyMCI7czoyMToiY3NzX3Jlc19wX2ljb25fbWFyZ2luIjtzOjI6IjIxIjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO3M6NDoiMTU2OCI7czo3OiJwb3N0X2lkIjtzOjM6IjYyOCI7czo5OiJtb2R1bGVfaWQiO3M6MTE6IkRTTENfQnV0dG9uIjt9[/dslc_module] 
[dslc_module]YTozMDp7czoxMToiYnV0dG9uX3RleHQiO3M6MTY6ImluZm9AZXhhbXBsZS5jb20iO3M6MTg6ImNzc19iZ19jb2xvcl9ob3ZlciI7czoxMToidHJhbnNwYXJlbnQiO3M6MTY6ImNzc19ib3JkZXJfY29sb3IiO3M6MTg6InJnYigyMzksIDIzNiwgMjM2KSI7czoxNjoiY3NzX2JvcmRlcl93aWR0aCI7czoxOiIwIjtzOjE3OiJjc3NfYm9yZGVyX3JhZGl1cyI7czoxOiIzIjtzOjE3OiJjc3NfbWFyZ2luX2JvdHRvbSI7czoxOiI5IjtzOjIwOiJjc3NfcGFkZGluZ192ZXJ0aWNhbCI7czoxOiI4IjtzOjIyOiJjc3NfcGFkZGluZ19ob3Jpem9udGFsIjtzOjI6IjI1IjtzOjE2OiJjc3NfYnV0dG9uX2NvbG9yIjtzOjE3OiJyZ2IoODgsIDE3OSwgMjM0KSI7czoyMjoiY3NzX2J1dHRvbl9jb2xvcl9ob3ZlciI7czoxNzoicmdiKDc1LCAxMjMsIDE5NCkiO3M6MjA6ImNzc19idXR0b25fZm9udF9zaXplIjtzOjI6IjIwIjtzOjE0OiJidXR0b25faWNvbl9pZCI7czo5OiJleHQtbWFpbDMiO3M6MTQ6ImNzc19pY29uX2NvbG9yIjtzOjI0OiJyZ2JhKDg4LCAxNzksIDIzNCwgMC40MikiO3M6MjA6ImNzc19pY29uX2NvbG9yX2hvdmVyIjtzOjE3OiJyZ2IoNzUsIDEyMywgMTk0KSI7czoxNToiY3NzX2ljb25fbWFyZ2luIjtzOjI6IjEyIjtzOjk6ImNzc19yZXNfdCI7czo3OiJlbmFibGVkIjtzOjIzOiJjc3NfcmVzX3RfbWFyZ2luX2JvdHRvbSI7czoyOiIyNSI7czoyNjoiY3NzX3Jlc190X3BhZGRpbmdfdmVydGljYWwiO3M6MToiMCI7czoyODoiY3NzX3Jlc190X3BhZGRpbmdfaG9yaXpvbnRhbCI7czoxOiI0IjtzOjI2OiJjc3NfcmVzX3RfYnV0dG9uX2ZvbnRfc2l6ZSI7czoyOiIxNiI7czoyMToiY3NzX3Jlc190X2ljb25fbWFyZ2luIjtzOjI6IjE0IjtzOjk6ImNzc19yZXNfcCI7czo3OiJlbmFibGVkIjtzOjIzOiJjc3NfcmVzX3BfbWFyZ2luX2JvdHRvbSI7czoyOiIyMCI7czoyNjoiY3NzX3Jlc19wX3BhZGRpbmdfdmVydGljYWwiO3M6MjoiMTIiO3M6Mjg6ImNzc19yZXNfcF9wYWRkaW5nX2hvcml6b250YWwiO3M6MjoiMTIiO3M6MjY6ImNzc19yZXNfcF9idXR0b25fZm9udF9zaXplIjtzOjI6IjIwIjtzOjIxOiJjc3NfcmVzX3BfaWNvbl9tYXJnaW4iO3M6MjoiMjIiO3M6MTg6Im1vZHVsZV9pbnN0YW5jZV9pZCI7czoyOiI1NyI7czo3OiJwb3N0X2lkIjtzOjM6IjYyOCI7czo5OiJtb2R1bGVfaWQiO3M6MTE6IkRTTENfQnV0dG9uIjt9[/dslc_module] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] 
[dslc_modules_area last="yes" first="no" size="8"] 
[dslc_module]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[/dslc_module] [/dslc_modules_area] [/dslc_modules_section]
',
			'section' => 'original'
		);


		//echo '<pre>';
		//var_dump($dslc_var_templates);die;
		//unset( $dslc_var_templates_pt['dslc_projects'] );
	}

	/**
	 * ----------------------------------------------------------------------
	 * Remove 'dslc_projects' type from $dslc_post_types to disable
	 * LC templates for it. We want users to be able to create
	 * complex layouts for each Project/Case Study
	 */
	if ( ! function_exists( 'disable_lc_post_templates' ) ) :
	add_action( 'init', 'disable_lc_post_templates', 9 );
	function disable_lc_post_templates() {
		global $dslc_var_templates_pt;
		unset( $dslc_var_templates_pt['dslc_projects'] );
	}
	endif; // disable_lc_post_templates

	/**
	* ----------------------------------------------------------------------
	* Alter LiveComposer Default Modules Styling
	* http://livecomposerplugin.com/docs/tuts/building-a-theme-defaults.html
	*/
	add_filter( 'dslc_module_options', 'lbmn_alter_lc_defaults', 10, 2 );
	function lbmn_alter_lc_defaults( $options, $id ) {

		// The array that will hold new defaults
		$new_defaults = array();


		$theme_ver_log = get_option( 'lbmn_theme_updates_log');

		if ( is_array($theme_ver_log) && in_array('1.0.1', $theme_ver_log) ) {
		// Do not apply new default styles for users updated theme from V.1
		// to not break their live website layouts


			/**
			 * --------------------------------------------
			 * Text module
			 */

			if ( $id == 'DSLC_Text_Simple' || $id == 'DSLC_Html' ) {
				$new_defaults = array(
					'css_custom' => 'enabled',
					'css_margin_bottom' => '30',
					'css_main_font_size' => '17',
					'css_main_font_weight' => '300',
					'css_main_font_family' => '',
					'css_main_line_height' => '27',
					'css_h1_font_size' => '66',
					'css_h1_font_weight' => '200',
					'css_h1_font_family' => '',
					'css_h1_line_height' => '70',
					'css_h1_margin_bottom' => '30',
					'css_h2_font_size' => '50',
					'css_h2_font_weight' => '200',
					'css_h2_font_family' => '',
					'css_h2_line_height' => '55',
					'css_h2_margin_bottom' => '24',
					'css_h3_font_size' => '42',
					'css_h3_font_weight' => '200',
					'css_h3_font_family' => '',
					'css_h3_line_height' => '48',
					'css_h3_margin_bottom' => '25',
					'css_h4_font_size' => '30',
					'css_h4_font_weight' => '300',
					'css_h4_font_family' => '',
					'css_h4_line_height' => '38',
					'css_h4_margin_bottom' => '20',
					'css_h5_font_size' => '24',
					'css_h5_font_weight' => '300',
					'css_h5_font_family' => '',
					'css_h5_line_height' => '33',
					'css_h5_margin_bottom' => '20',

					'css_h6_font_size' => '',
					'css_h6_font_family' => '',
					'css_h6_font_weight' => '',
					'css_h6_line_height' => '',
					'css_h6_margin_bottom' => '',
					'css_h6_padding_vertical' => '',
					'css_h6_padding_horizontal' => '',
					'css_h6_text_align' => '',
					'css_h6_border_color' => '',
					'css_h6_border_width' => '',
					'css_h6_border_trbl' => '',
					'css_h6_border_radius_top' => '',
					'css_h6_border_radius_bottom' => '',

					'css_blockquote_font_family' => '',
					'css_button_font_family' => '',
					'css_button_font_family' => '',

					'css_res_t' => 'enabled',
					'css_res_t_margin_bottom' => '39',
					'css_res_t_main_font_size' => '16',
					'css_res_t_main_line_height' => '26',
					'css_res_t_h2_font_size' => '40',
					'css_res_t_h2_line_height' => '46',
					'css_res_t_h2_margin_bottom' => '0',
					'css_res_t_h3_font_size' => '24',
					'css_res_t_h3_line_height' => '26',
					'css_res_t_h3_margin_bottom' => '30',
					'css_res_p' => 'enabled',
					'css_res_ph_main_font_size' => '14',
					'css_res_ph_main_line_height' => '21',
					'css_res_ph_h2_font_size' => '34',
					'css_res_ph_h2_line_height' => '32',
					'css_res_p_h2_margin_bottom' => '10',
					'css_res_ph_h3_font_size' => '18',
					'css_res_ph_h3_line_height' => '24',
					'css_res_p_h3_margin_bottom' => '20',
				);
			}


			/**
			 * --------------------------------------------
			 * Button module
			 */
			if ( $id == 'DSLC_Button' ) {
				$new_defaults = array(
					'button_text' => 'Click to edit',
					'button_url' => '#',
					'css_bg_color' => 'transparent',
					'css_border_color' => 'rgb(239, 236, 236)',
					'css_border_color_hover' => 'rgb(75, 123, 194)',
					'css_border_width' => '1',
					'css_padding_horizontal' => '18',
					'css_button_color' => 'rgb(42, 160, 239)',
					'css_button_font_size' => '17',
					'css_button_font_weight' => '300',
					'css_button_font_family' => '',
				);
			}


			/**
			 * --------------------------------------------
			 * Title module
			 */
			if ( $id == 'DSLC_TP_Title' ) {
				$new_defaults = array(
					'css_font_size' => '50',
					'css_font_weight' => '200',
					'css_font_family' => '',
					'css_line_height' => '55',
				);
			}

			/**
			 * --------------------------------------------
			 * Meta module
			 */
			if ( $id == 'DSLC_TP_Meta' ) {
				$new_defaults = array(
					'tp_elements' => 'date author category tags comments ',
					'format' => 'vertical',
					'color' => 'rgb(97, 103, 108)',
					'font_size' => '15',
					'css_font_weight' => '300',
					'css_font_family' => '',
					'css_line_height' => '22',
				);
			}

			/**
			 * --------------------------------------------
			 * Accordion module
			 */
			if ( $id == 'DSLC_Accordion' ) {
				$new_defaults = array(
					'css_title_font_family' => '',
					'css_content_font_family' => '',
				);
			}

			/**
			 * --------------------------------------------
			 * Blog module
			 */
			if ( $id == 'DSLC_Blog' ) {
				$new_defaults = array(
					'css_title_font_family' => '',
					'css_excerpt_font_family' => '',
					'css_button_font_family' => '',
					'css_main_heading_font_family' => '',
					'css_main_heading_link_font_family' => '',
				);
			}


		} else {
			// Apply new module styling rules since V.1.1

			/**
			 * --------------------------------------------
			 * Text module
			 */
			if ( $id == 'DSLC_Text_Simple' || $id == 'DSLC_Html' || $id == 'DSLC_TP_Content' ) { 
				$new_defaults = array(
					'css_main_font_size' => '',
					'css_main_font_family' => '',
					'css_main_font_weight' => '',
					'css_main_line_height' => '',

					'css_h1_font_size' => '',
					'css_h1_font_family' => '',
					'css_h1_font_weight' => '',
					'css_h1_line_height' => '',
					'css_h1_margin_bottom' => '',

					'css_h2_font_size' => '',
					'css_h2_font_family' => '',
					'css_h2_font_weight' => '',
					'css_h2_line_height' => '',
					'css_h2_margin_bottom' => '',

					'css_h3_font_size' => '',
					'css_h3_font_family' => '',
					'css_h3_font_weight' => '',
					'css_h3_line_height' => '',
					'css_h3_margin_bottom' => '',

					'css_h4_font_size' => '',
					'css_h4_font_family' => '',
					'css_h4_font_weight' => '',
					'css_h4_line_height' => '',
					'css_h4_margin_bottom' => '',

					'css_h5_font_size' => '',
					'css_h5_font_family' => '',
					'css_h5_font_weight' => '',
					'css_h5_line_height' => '',
					'css_h5_margin_bottom' => '',

					'css_h6_font_size' => '',
					'css_h6_font_family' => '',
					'css_h6_font_weight' => '',
					'css_h6_line_height' => '',
					'css_h6_margin_bottom' => '',

					'css_blockquote_font_family' => '',
					'css_button_font_family' => '',
					'css_button_font_family' => '',

					'css_li_font_family' => '',
					'css_li_font_size' => '',
					'css_li_font_weight' => '',
					'css_li_line_height' => '',
					'css_ul_margin_bottom' => '',
					'css_ul_margin_left' => '',
					'css_ul_li_margin_bottom' => '',

					'css_inputs_font_family' => '',
					'css_inputs_font_size' => '',
					'css_inputs_font_weight' => '',
					'css_inputs_line_height' => '',
				);
			}


			/**
			 * --------------------------------------------
			 * Button module
			 */
			if ( $id == 'DSLC_Button' ) {
				$new_defaults = array(
					'button_text' => 'Click to edit',
					'button_url' => '#',
					'css_bg_color' => 'transparent',
					'css_border_color' => 'rgb(226, 223, 223)',
					'css_border_color_hover' => 'rgb(75, 123, 194)',
					'css_border_width' => '1',
					'css_border_radius' => '4',

					'css_margin_bottom' => '50', // '15',

					'css_padding_vertical' => '14',
					'css_padding_horizontal' => '18',

					'css_button_color' => 'rgb(42, 160, 239)',
					'css_button_color_hover' => 'rgb(255, 255, 255)',
					'css_button_font_size' => '17',
					'css_button_font_weight' => '300',
					'css_button_font_family' => '',

					'css_icon_margin' => '10',

					'css_res_p_padding_vertical' => '',
					'css_res_p_padding_horizontal' => '',
					'css_res_p_button_font_size' => '',
					'css_res_p_icon_margin' => '',

					'css_res_t_margin_bottom' => '',
					'css_res_t_padding_vertical' => '',
					'css_res_t_padding_horizontal' => '',
					'css_res_t_button_font_size' => '',
					'css_res_t_icon_margin' => '',
				);
			}


			/**
			 * --------------------------------------------
			 * Info Box module
			 */
			if ( $id == 'DSLC_Info_Box' ) { 
				$new_defaults = array(
					'elements' => 'icon title content button ',
					'text_align' => 'left',
					'css_margin_bottom' => '50',
					'css_icon_bg_color' => 'transparent',
					'css_icon_border_color' => 'rgba(89, 175, 226, 0.3)',
					'css_icon_border_width' => '1',
					'css_icon_color' => 'rgb(89, 175, 226)',
					'css_icon_border_radius' => '28',
					'icon_id' => 'smile',
					'css_icon_margin_right' => '25',
					'icon_position' => 'aside',
					'css_icon_wrapper_width' => '72',
					'css_icon_width' => '28',


					'title' => 'Click to edit this heading',
					'css_title_color' => '',
					'css_title_font_size' => '27',
					'css_title_font_weight' => '300',
					'css_title_font_family' => '',
					'css_title_line_height' => '30',
					'css_title_margin' => '20',

					'content' => '<p>This is just placeholder text. To change it move your mouse this block and click "Edit Content" label.</p>',
					'css_content_font_weight' => '',
					'css_content_font_family' => '',
					'css_content_line_height' => '22',
					'css_content_margin' => '20',

					'button_title' => 'Click to edit',
					'css_button_bg_color' => 'rgba(0, 0, 0, 0)',
					'css_button_bg_color_hover' => 'rgb(75, 123, 194)',
					'css_button_color' => '',
					'css_button_icon_color' => '',
						'css_button_border_width' => '1',
						'css_button_border_color' => 'rgb(226, 223, 223)',
						'css_button_border_color_hover' => 'rgb(75, 123, 194)',
					'css_button_font_size' => '13',
					'css_button_font_weight' => '400',
					'css_button_font_family' => '',
					'css_button_margin_top' => '20',
					'css_button_margin_right' => '12',
					'button_icon_id' => 'ok',

					'button_2_title' => 'Click to edit',
					'css_button_2_bg_color' => 'rgba(0, 0, 0, 0)',
					'css_button_2_bg_color_hover' => 'rgb(75, 123, 194)',
					'css_button_2_color' => '',
					'css_button_2_icon_color' => '',
						'css_button_2_border_width' => '1',
						'css_button_2_border_color' => 'rgb(226, 223, 223)',
						'css_button_2_border_color_hover' => 'rgb(75, 123, 194)',
					'css_button_2_font_size' => '13',
					'css_button_2_font_weight' => '400',
					'css_button_2_font_family' => '',
					'css_button_2_margin_top' => '20',
					'css_button_2_margin_right' => '12',
					'button_2_icon_id' => 'ok',

					'css_res_t' => 'disabled',
					'css_res_t_margin_bottom' => '',
					'css_res_t_icon_margin_right' => '20',
					'css_res_t_icon_wrapper_width' => '50',
					'css_res_t_icon_width' => '21',
						'css_res_t_title_font_size' => '21',
						'css_res_t_title_line_height' => '27',
						'css_res_t_title_margin' => '18',
					'css_res_t_content_font_size' => '',
					'css_res_t_content_line_height' => '',
					'css_res_t_content_margin' => '20',
						'css_res_t_button_font_size' => '',
						'css_res_t_button_padding_vertical' => '',
						'css_res_t_button_padding_horizontal' => '',
						'css_res_t_button_icon_margin' => '10',

					'css_res_p' => 'disabled',
					'css_res_p_margin_bottom' => '',
					'css_res_p_icon_margin_top' => '-2',
					'css_res_p_icon_margin_right' => '20',
					'css_res_p_icon_wrapper_width' => '60',
					'css_res_p_icon_width' => '24',
					'css_res_p_title_font_size' => '23',
					'css_res_p_title_line_height' => '27',
					'css_res_p_title_margin' => '16',
					'css_res_p_content_margin' => '20',
					'css_res_p_button_font_size' => '',
					'css_res_p_button_padding_vertical' => '',
					'css_res_p_button_padding_horizontal' => '',
					'css_res_p_button_icon_margin' => '10',

				);
			}

			if ( $id == 'DSLC_Image' ) {
				$new_defaults = array(
					'css_ct_font_size' => '14',
					'css_ct_font_weight' => '300',
					'css_ct_font_family' => '',
				);
			}

			/**
			 * --------------------------------------------
			 * Title module
			 */
			if ( $id == 'DSLC_TP_Title' ) {
				$new_defaults = array(
					'css_font_size' => '50',
					'css_font_weight' => '200',
					'css_font_family' => '',
					'css_line_height' => '55',
				);
			}

			/**
			 * --------------------------------------------
			 * Meta module
			 */
			if ( $id == 'DSLC_TP_Meta' ) {
				$new_defaults = array(
					'tp_elements' => 'date author category tags comments ',
					'format' => 'vertical',
					'color' => 'rgb(97, 103, 108)',
					'font_size' => '15',
					'css_font_weight' => '300',
					'css_font_family' => '',
					'css_line_height' => '22',
				);
			}

			/**
			 * --------------------------------------------
			 * Accordion module
			 */
			if ( $id == 'DSLC_Accordion' ) {
				$new_defaults = array(
					'css_title_font_family' => '',
					'css_content_font_family' => '',
				);
			}

			/**
			 * --------------------------------------------
			 * Blog module
			 */
			if ( $id == 'DSLC_Blog' ) {
				$new_defaults = array(
					// 'columns' => '12',
					// 'categories' => '54 ',
					// 'elements' => 'main_heading ',
					// 'post_elements' => 'title ',
					// 'css_sep_border_color' => 'rgba(26, 30, 32, 0.5)',
					// 'css_sep_height' => '6',
					// 'css_sep_style' => 'dotted',
					// 'css_thumb_border_radius_top' => '0',
					// 'thumb_resize_height' => '180',
					// 'thumb_resize_width_manual' => '280',
					// 'css_main_bg_color' => 'transparent',
					// 'css_main_border_width' => '0',
					// 'css_main_padding_vertical' => '0',
					// 'css_main_padding_horizontal' => '0',
					// 'css_main_text_align' => 'left',
					// 'title_color' => 'rgb(255, 255, 255)',
					// 'title_color_hover' => 'rgb(86, 174, 227)',
					// 'css_title_font_weight' => '300',
					'css_title_font_family' => '',
					// 'title_line_height' => '26',
					// 'title_margin' => '0',
					// 'css_excerpt_color' => 'rgb(97, 103, 108)',
					// 'css_excerpt_font_size' => '15',
					// 'css_excerpt_font_weight' => '300',
					'css_excerpt_font_family' => '',
					// 'excerpt_length' => '22',
					// 'button_text' => 'Continue reading',
					// 'css_button_bg_color' => 'transparent',
					// 'css_button_border_width' => '1',
					// 'css_button_border_color' => 'rgba(113, 190, 241, 0.24)',
					// 'css_button_border_color_hover' => 'rgb(75, 123, 194)',
					// 'css_button_color' => 'rgb(42, 160, 239)',
					// 'css_button_font_size' => '13',
					// 'css_button_font_weight' => '400',
					'css_button_font_family' => '',
					// 'css_button_padding_horizontal' => '15',
					// 'main_heading_title' => 'Latest blog posts',
					// 'main_heading_link_title' => '',
					// 'css_main_heading_color' => 'rgba(255, 255, 255, 0.56)',
					// 'css_main_heading_font_size' => '24',
					// 'css_main_heading_font_weight' => '300',
					'css_main_heading_font_family' => '',
					// 'css_main_heading_line_height' => '36',
					// 'css_main_heading_link_color' => 'rgb(42, 160, 239)',
					// 'css_main_heading_link_font_size' => '18',
					// 'css_main_heading_link_font_weight' => '300',
					'css_main_heading_link_font_family' => '',
					// 'css_main_heading_link_padding_ver' => '12',
					// 'css_main_heading_sep_color' => 'rgba(79, 79, 79, 0.27)',
					// 'css_arrows_bg_color' => 'transparent',
					// 'css_arrows_border_color' => 'rgba(130, 129, 129, 0.11)',
					// 'css_arrows_border_width' => '1',
					// 'css_arrows_color' => 'rgba(141, 141, 141, 0.45)',
					// 'css_arrows_margin_top' => '4',
					// 'css_arrows_size' => '43',
					// 'css_arrows_arrow_size' => '11',
					// 'css_circles_color' => 'rgb(228, 228, 228)',
					// 'css_circles_margin_top' => '0',
					// 'css_circles_spacing' => '6',
				);
			}

			/**
			 * ----------------------------------------------------------------------
			 * Partners Module
			 */

			if ( $id == 'DSLC_Partners' ) { 
				$new_defaults = array(
					'elements' => 'main_heading filters ',

					'css_thumbnail_margin_bottom' => '20',
					'css_thumbnail_padding_vertical' => '0',
					'thumb_resize_width' => '',
					'css_title_color' => '',
					'css_title_font_size' => '21',
					'css_title_font_weight' => '300',
					'css_title_font_family' => '',
					'css_title_line_height' => '27',
					'css_excerpt_color' => '',
					'css_excerpt_font_size' => '14',
					'css_excerpt_font_weight' => '300',
					'css_excerpt_font_family' => '',

					'main_heading_title' => 'Click to edit this heading',
					'main_heading_link_title' => 'View all partners',

					'css_main_heading_font_size' => '27',
					'css_main_heading_font_weight' => '300',
					'css_main_heading_font_family' => '',
					'css_main_heading_line_height' => '38',

					'css_main_heading_link_font_size' => '16',
					'css_main_heading_link_font_weight' => '300',
					'css_main_heading_link_font_family' => '',
					'css_main_heading_sep_color' => 'rgba(79, 79, 79, 0.25)',
					'css_heading_margin_bottom' => '50',

					'css_filter_border_color' => 'rgba(130, 129, 129, 0.11)',
					'css_filter_font_size' => '14',
					'css_filter_font_weight' => '400',
					'css_filter_font_family' => '',
					'css_filter_padding_horizontal' => '16',
					'css_filter_position' => 'right',
					'css_filter_margin_bottom' => '50',

					'css_arrows_bg_color' => 'transparent',
					'css_arrows_border_color' => 'rgba(170, 170, 170, 0.28)',
					'css_arrows_border_color_hover' => 'rgb(88, 144, 229)',
					'css_arrows_border_width' => '1',
					'css_arrows_color' => 'rgba(196, 196, 196, 0.68)',
					'css_arrows_size' => '40',
					'css_arrows_arrow_size' => '11',

					'css_circles_color' => 'rgba(185, 185, 185, 0.17)',
					'css_circles_color_active' => 'rgba(153, 153, 153, 0.78)',
					'css_circles_margin_top' => '0',
					'css_circles_size' => '8',
					'css_circles_spacing' => '10',

					'css_res_p_thumbnail_padding_vertical' => '10',
					'css_res_p_title_font_size' => '21',
					'css_res_p_title_line_height' => '27',
					'css_res_p_excerpt_font_size' => '',
					'css_res_p_main_heading_font_size' => '23',
					'css_res_p_main_heading_line_height' => '27',
					'css_res_p_main_heading_link_font_size' => '16',
					'css_res_p_heading_margin_bottom' => '0',
					'css_res_p_filter_font_size' => '',

					'css_pag_align' => 'center',
					'css_pag_border_color' => 'rgba(170, 170, 170, 0.28)',
					'css_pag_item_font_size' => '14',
					'css_pag_item_font_weight' => '400',
					'css_pag_item_font_family' => '',
					'css_pag_item_padding_vertical' => '14',
					'css_pag_item_padding_horizontal' => '16',
					'css_pag_item_spacing' => '14',
				);
			}

			/**
			 * ----------------------------------------------------------------------
			 * Testimonials Module
			 */

			if ( $id == 'DSLC_Testimonials' ) {
				$new_defaults = array(
					'type' => 'carousel',
					'elements' => 'main_heading filters ',

					'amount' => '3',
					'columns' => '12',
					'order' => 'ASC',

					'css_main_bg_color' => 'transparent',
					'css_main_padding_vertical' => '0',
					'css_main_padding_horizontal' => '0',

					'css_quote_border_color' => 'transparent',
					'css_quote_border_width' => '0',
					'css_quote_color' => '',
					'css_quote_font_size' => '20',
					'css_quote_font_weight' => '300',
					'css_quote_line_height' => '30',
					'css_quote_margin' => '0',
					'css_quote_padding_bottom' => '0',

					'author_pos' => 'outside right',
					'css_author_margin_left' => '30',
					'css_avatar_bg_color' => 'rgba(24, 24, 25, 0.05)',
					'css_avatar_border_color' => 'rgba(0, 0, 0, 0.06)',
					'css_avatar_border_width' => '1',
					'css_avatar_padding' => '6',
					'css_avatar_size' => '90',

					'css_name_color' => '',
					'css_name_font_size' => '24',
					'css_name_font_weight' => '300',
					'css_name_margin_bottom' => '6',
					'css_name_margin_top' => '20',
					'css_position_color' => '',
					'css_position_font_size' => '16',
					'css_position_font_weight' => '300',


					'css_thumbnail_margin_bottom' => '20',
					'css_thumbnail_padding_vertical' => '0',
					'thumb_resize_width' => '',
					'css_title_color' => '',
					'css_title_font_size' => '21',
					'css_title_font_weight' => '300',
					'css_title_font_family' => '',
					'css_title_line_height' => '27',
					'css_excerpt_color' => '',
					'css_excerpt_font_size' => '14',
					'css_excerpt_font_weight' => '300',
					'css_excerpt_font_family' => '',

					'css_quote_font_family' => '',
					'css_name_font_family' => '',
					'css_position_font_family' => '',

					'main_heading_title' => 'Click to edit this heading',
					'main_heading_link_title' => 'View all testimonials',

					'css_main_heading_font_size' => '27',
					'css_main_heading_font_weight' => '300',
					'css_main_heading_font_family' => '',
					'css_main_heading_line_height' => '38',

					'css_main_heading_link_font_size' => '16',
					'css_main_heading_link_font_weight' => '300',
					'css_main_heading_link_font_family' => '',
					'css_main_heading_sep_color' => 'rgba(79, 79, 79, 0.25)',
					'css_heading_margin_bottom' => '50',

					'css_filter_border_color' => 'rgba(130, 129, 129, 0.11)',
					'css_filter_font_size' => '14',
					'css_filter_font_weight' => '400',
					'css_filter_font_family' => '',
					'css_filter_padding_horizontal' => '16',
					'css_filter_position' => 'right',
					'css_filter_margin_bottom' => '50',

					'css_arrows_bg_color' => 'transparent',
					'css_arrows_border_color' => 'rgba(170, 170, 170, 0.28)',
					'css_arrows_border_color_hover' => 'rgb(88, 144, 229)',
					'css_arrows_border_width' => '1',
					'css_arrows_color' => 'rgba(196, 196, 196, 0.68)',
					'css_arrows_size' => '40',
					'css_arrows_arrow_size' => '11',

					'css_circles_color' => 'rgba(185, 185, 185, 0.17)',
					'css_circles_color_active' => 'rgba(153, 153, 153, 0.78)',
					'css_circles_margin_top' => '0',
					'css_circles_size' => '8',
					'css_circles_spacing' => '10',

					'css_pag_align' => 'center',
					'css_pag_border_color' => 'rgba(170, 170, 170, 0.28)',
					'css_pag_item_font_size' => '14',
					'css_pag_item_font_weight' => '400',
					'css_pag_item_font_family' => '',
					'css_pag_item_padding_vertical' => '14',
					'css_pag_item_padding_horizontal' => '16',
					'css_pag_item_spacing' => '14',

					'css_res_p_thumbnail_padding_vertical' => '10',
					'css_res_p_title_font_size' => '21',
					'css_res_p_title_line_height' => '27',
					'css_res_p_excerpt_font_size' => '',
					'css_res_p_main_heading_font_size' => '23',
					'css_res_p_main_heading_line_height' => '27',
					'css_res_p_main_heading_link_font_size' => '16',
					'css_res_p_heading_margin_bottom' => '0',
					'css_res_p_filter_font_size' => '',

					'css_res_p_main_padding_vertical' => '0',
					'css_res_p_main_padding_horizontal' => '0',
					'css_res_p_quote_margin' => '0',
					'css_res_p_author_margin_bottom' => '30',
					'css_res_p_author_margin_right' => '0',

					'css_res_p_avatar_padding' => '4',
					'css_res_p_name_font_size' => '19',
					'css_res_p_name_margin_bottom' => '4',
					'css_res_p_position_font_size' => '14',
					'css_res_p_main_heading_link_padding_ver' => '15',
				);
			}

			/**
			 * ----------------------------------------------------------------------
			 * Projects Modules
			 */

			if ( $id == 'DSLC_Projects' ) {
				$new_defaults = array(
					'type' => 'carousel',
					'orientation' => 'vertical',
					'elements' => '',
					'amount' => '6',
					'columns' => '4',
					'post_elements' => 'thumbnail title excerpt button ',

					'css_thumbnail_border_radius_top' => '0',
					'thumb_resize_height' => '260',
					'thumb_resize_width' => '120',
					'thumb_width' => '100',
					'css_main_text_align' => 'left',

					'main_heading_title' => 'Click to edit this heading',
					'main_heading_link_title' => 'View all projects',

					'css_main_heading_font_size' => '27',
					'css_main_heading_font_weight' => '300',
					'css_main_heading_font_family' => '',
					'css_main_heading_line_height' => '38',

					'css_main_heading_link_font_size' => '16',
					'css_main_heading_link_font_weight' => '300',
					'css_main_heading_link_font_family' => '',
					'css_main_heading_sep_color' => 'rgba(79, 79, 79, 0.25)',
					'css_heading_margin_bottom' => '50',

					'css_filter_border_color' => 'rgba(130, 129, 129, 0.11)',
					'css_filter_font_size' => '14',
					'css_filter_font_weight' => '400',
					'css_filter_font_family' => '',
					'css_filter_padding_horizontal' => '16',
					'css_filter_position' => 'right',
					'css_filter_margin_bottom' => '50',

					'css_arrows_bg_color' => 'transparent',
					'css_arrows_border_color' => 'rgba(170, 170, 170, 0.28)',
					'css_arrows_border_color_hover' => 'rgb(88, 144, 229)',
					'css_arrows_border_width' => '1',
					'css_arrows_color' => 'rgba(196, 196, 196, 0.68)',
					'css_arrows_size' => '40',
					'css_arrows_arrow_size' => '11',

					'css_circles_color' => 'rgba(185, 185, 185, 0.17)',
					'css_circles_color_active' => 'rgba(153, 153, 153, 0.78)',
					'css_circles_margin_top' => '0',
					'css_circles_size' => '8',
					'css_circles_spacing' => '10',

					'css_pag_align' => 'center',
					'css_pag_border_color' => 'rgba(170, 170, 170, 0.28)',
					'css_pag_item_font_size' => '14',
					'css_pag_item_font_weight' => '400',
					'css_pag_item_font_family' => '',
					'css_pag_item_padding_vertical' => '14',
					'css_pag_item_padding_horizontal' => '16',
					'css_pag_item_spacing' => '14',

					'css_title_color' => '',
					'css_title_font_size' => '21',
					'css_title_font_weight' => '300',
					'css_title_font_family' => '',
					'css_title_line_height' => '27',

					'css_cats_color' => 'rgb(171, 171, 171)',
					'css_cats_font_size' => '12',
					'css_cats_font_weight' => '300',
					'css_cats_font_family' => '',
					'css_cats_margin-bottom' => '8',

					'carousel_elements' => 'circles ',
					'css_main_border_width' => '0',
					'css_main_border_radius_bottom' => '0',
					'css_main_padding_vertical' => '30',
					'css_main_padding_horizontal' => '40',
					'css_main_text_align' => 'center',

					'css_excerpt_border_width' => '0',
					'css_excerpt_font_weight' => '300',
					'css_excerpt_font_family' => '',
					'css_excerpt_padding' => '0',

					'button_text' => 'View Project',
					'css_button_bg_color' => 'transparent',
					'css_button_border_width' => '1',
					'css_button_border_color' => 'rgb(226, 223, 223)',
					'css_button_border_color_hover' => 'rgb(71, 124, 204)',
					'css_button_color' => '',
					'css_button_color_hover' => 'rgb(216, 113, 113)',
					'css_button_font_size' => '14',
					'css_button_font_weight' => '300',
					'css_button_font_family' => '',
					'css_button_padding_vertical' => '12',

					'css_res_p_title_font_size' => '21',
					'css_res_p_title_line_height' => '27',
					'css_res_p_excerpt_font_size' => '',
					'css_res_p_main_heading_font_size' => '23',
					'css_res_p_main_heading_line_height' => '27',
					'css_res_p_main_heading_link_font_size' => '16',
					'css_res_p_heading_margin_bottom' => '0',
					'css_res_p_filter_font_size' => '',

					'css_res_t_title_font_size' => '21',
					'css_res_t_title_line_height' => '27',
					'css_res_t_excerpt_font_size' => '',
					'css_res_t_main_heading_font_size' => '23',
					'css_res_t_main_heading_line_height' => '27',
					'css_res_t_main_heading_link_font_size' => '16',
					'css_res_t_heading_margin_bottom' => '0',
					'css_res_t_filter_font_size' => '',


					'css_res_t_button_font_size' => '',
					'css_res_t_button_padding_vertical' => '',
					'css_res_t_button_padding_horizontal' => '',
					'css_res_t_button_icon_margin' => '10',
				);
			}

			/**
			 * ----------------------------------------------------------------------
			 * Posts Module
			 */

			if ( $id == 'DSLC_Posts' ) { 
				$new_defaults = array(
				'type' => 'carousel',
				'orientation' => 'vertical',
				'elements' => 'main_heading',
				'amount' => '6',
				'columns' => '4',
				'post_elements' => 'thumbnail title excerpt button ',

				'css_thumb_border_radius_top' => '0',
				'css_main_text_align' => 'left',
				'thumb_width' => '100',
				'thumb_margin' => '25',
				'thumb_resize_height' => '255',
				'thumb_resize_width_manual' => '400',
				'thumb_resize_width' => '384',

				'main_heading_title' => 'Click to edit this heading',
				'main_heading_link_title' => 'View all projects',

				'css_main_heading_font_size' => '27',
				'css_main_heading_font_weight' => '300',
				'css_main_heading_font_family' => '',
				'css_main_heading_line_height' => '38',

				'css_main_heading_link_font_size' => '16',
				'css_main_heading_link_font_weight' => '300',
				'css_main_heading_link_font_family' => '',
				'css_main_heading_sep_color' => 'rgba(79, 79, 79, 0.25)',
				'css_heading_margin_bottom' => '50',

				'css_filter_border_color' => 'rgba(130, 129, 129, 0.11)',
				'css_filter_font_size' => '14',
				'css_filter_font_weight' => '400',
				'css_filter_font_family' => '',
				'css_filter_padding_horizontal' => '16',
				'css_filter_position' => 'right',
				'css_filter_margin_bottom' => '50',

				'css_arrows_bg_color' => 'transparent',
				'css_arrows_border_color' => 'rgba(170, 170, 170, 0.28)',
				'css_arrows_border_color_hover' => 'rgb(88, 144, 229)',
				'css_arrows_border_width' => '1',
				'css_arrows_color' => 'rgba(196, 196, 196, 0.68)',
				'css_arrows_size' => '40',
				'css_arrows_arrow_size' => '11',

				'css_circles_color' => 'rgba(185, 185, 185, 0.17)',
				'css_circles_color_active' => 'rgba(153, 153, 153, 0.78)',
				'css_circles_margin_top' => '0',
				'css_circles_size' => '8',
				'css_circles_spacing' => '10',

				'css_pag_align' => 'center',
				'css_pag_border_color' => 'rgba(170, 170, 170, 0.28)',
				'css_pag_item_font_size' => '14',
				'css_pag_item_font_weight' => '400',
				'css_pag_item_font_family' => '',
				'css_pag_item_padding_vertical' => '14',
				'css_pag_item_padding_horizontal' => '16',
				'css_pag_item_spacing' => '14',


				// 'title_margin' => '12',

				'css_title_color' => '',
				'title_font_size' => '24',
				'css_title_font_weight' => '300',
				'css_title_font_family' => '',
				'title_line_height' => '27',

				// 'css_cats_color' => 'rgb(171, 171, 171)',
				// 'css_cats_font_size' => '12',
				// 'css_cats_font_weight' => '300',
				// 'css_cats_font_family' => '',
				// 'css_cats_margin-bottom' => '8',

				'css_excerpt_border_width' => '0',
				'css_excerpt_font_weight' => '300',
				'css_excerpt_font_family' => '',
				'css_excerpt_padding' => '0',

				'css_excerpt_border_width' => '0',

				'css_excerpt_font_size' => '14',
				'css_excerpt_font_weight' => '300',
				'excerpt_length' => '16',
				'css_excerpt_color' => '',


				'carousel_elements' => 'arrows circles ',
				'css_main_border_width' => '0',
				'css_main_border_radius_bottom' => '0',
				'css_main_padding_vertical' => '0',
				'css_main_padding_horizontal' => '0',
				'css_main_text_align' => 'left',

				'css_meta_border_width' => '0',
				'css_meta_border_trbl' => 'bottom ',
				'css_meta_font_family' => '',
				'css_meta_link_color' => '',
				'css_meta_link_color_hover' => '',

				



				'button_text' => 'View Project',
				'css_button_bg_color' => 'transparent',
				'css_button_border_width' => '1',
				'css_button_border_color' => 'rgb(226, 223, 223)',
				'css_button_border_color_hover' => 'rgb(71, 124, 204)',
				'css_button_color' => '',
				'css_button_color_hover' => 'rgb(255, 255, 255)',
				'css_button_font_size' => '14',
				'css_button_font_weight' => '300',
				'css_button_font_family' => '',
				'css_button_padding_vertical' => '12',

				'css_res_p_title_font_size' => '21',
				'css_res_p_title_line_height' => '27',
				'css_res_p_excerpt_font_size' => '',
				'css_res_p_main_heading_font_size' => '23',
				'css_res_p_main_heading_line_height' => '27',
				'css_res_p_main_heading_link_font_size' => '16',
				'css_res_p_heading_margin_bottom' => '0',
				'css_res_p_filter_font_size' => '',

				'css_res_t_title_font_size' => '21',
				'css_res_t_title_line_height' => '27',
				'css_res_t_excerpt_font_size' => '',
				'css_res_t_main_heading_font_size' => '23',
				'css_res_t_main_heading_line_height' => '27',
				'css_res_t_main_heading_link_font_size' => '16',
				'css_res_t_heading_margin_bottom' => '0',
				'css_res_t_filter_font_size' => '',

				'css_res_p_thumb_margin' => '14',
				'css_res_p_main_padding_vertical' => '0',
				'css_res_p_main_padding_horizontal' => '0',


				'css_res_t_button_font_size' => '',
				'css_res_t_button_padding_vertical' => '',
				'css_res_t_button_padding_horizontal' => '',
				'css_res_t_button_icon_margin' => '10',
				);
			}
			

		} // else in_array('1.0.1')

		// Call the function that alters the defaults and return
		return dslc_set_defaults( $new_defaults, $options );
	}


} //if ( defined( 'DS_LIVE_COMPOSER_URL' ) )


/**
 * ----------------------------------------------------------------------
 * Custom shortcodes specially used to extend Live Composer functionality
 */

/**
 * Add Shortcode: [nextpost_url] [prevpost_url]
 * Output an URL to the next previous post the same way as next post link works
 * https://codex.wordpress.org/Function_Reference/get_next_posts_link
 * http://wordpress.org/support/topic/nextpreviews-post-url-only
 * https://codex.wordpress.org/Function_Reference/get_adjacent_post
 */

// [nextpost_url]
add_shortcode( 'lbmn_nextpost_url', 'lbmn_nextpost_url_shortcode' );
function lbmn_nextpost_url_shortcode( $atts ) {

	// Attributes
	extract( shortcode_atts(
		array(
			'previous' => false,
			// Whether to retrieve previous or next post.
			'in_same_cat' => false,
			// Whether post should be in same category. Whether post should be in same category.
			'excluded_categories' => '',
			// Excluded categories IDs.
		), $atts )
	);

	// Code
	$output = get_permalink(get_adjacent_post($in_same_cat,$excluded_categories,$previous));
	// for your reference:  get_adjacent_post( $in_same_cat, $excluded_categories, $previous )
	return $output;
}

// [prevpost_url]
add_shortcode( 'lbmn_prevpost_url', 'lbmn_prevpost_url_shortcode' );
function lbmn_prevpost_url_shortcode( $atts ) {

	// Attributes
	extract( shortcode_atts(
		array(
			'previous' => true,
			// Whether to retrieve previous or next post.
			'in_same_cat' => false,
			// Whether post should be in same category. Whether post should be in same category.
			'excluded_categories' => '',
			// Excluded categories IDs.
		), $atts )
	);

	// Code
	$output = get_permalink(get_adjacent_post($in_same_cat,$excluded_categories,$previous));
	// for your reference:  get_adjacent_post( $in_same_cat, $excluded_categories, $previous )
	return $output;
}

/**
 * Add Shortcode:
 * [lbmn_pagetitle]
 *
 * Outputs the curent page title
 * http://codex.wordpress.org/Function_Reference/the_title
 */
add_shortcode( 'lbmn_pagetitle', 'lbmn_pagetitle_shortcode' );
function lbmn_pagetitle_shortcode() {
	// Code
	$output = the_title( '', '', false ); // get_the_title() -- doesn't work in LiveComposer
	return $output;
}

/**
 * Add Shortcode:
 * [lbmn_authorbio]
 *
 * Outputs the curent author bio info
 * http://codex.wordpress.org/Function_Reference/get_the_author_meta
 */
add_shortcode( 'lbmn_authorbio', 'lbmn_authorbio_shortcode' );
function lbmn_authorbio_shortcode() {
	$output = get_the_author_meta( 'description');
	if ( !$output ) {
		$output = ' ';
		// to prevent "Looks like there is no content" message
		// in the Live Composer
	}
	return $output;
}

/**
 * Add Shortcode:
 * [lbmn_bloghome]
 *
 * Outputs the blog index page URL
 * http://codex.wordpress.org/Function_Reference/get_option
 */
add_shortcode( 'lbmn_bloghome', 'lbmn_bloghome_shortcode' );
function lbmn_bloghome_shortcode() {
	// Code
	$output = home_url();
	return $output;
}

/**
 * Add Shortcode:
 * [lbmn_postpagination]
 *
 * Outputs single post pagination
 */
add_shortcode( 'lbmn_postpagination', 'lbmn_postpagination_shortcode' );
function lbmn_postpagination_shortcode() {
	$output = wp_link_pages( array(
		'before' => '<div class="page-links"><span class="page-links__title">' . __( 'Pages:', 'lbmn' ) . '</span><span class="page-numbers">',
		'after'  => '</span></div>',
		'echo'   => 0
	) );

	if ( !$output ) {
		$output = ' ';
		// to prevent "Looks like there is no content" message
		// in the Live Composer
	}
	return $output;
}

/**
 * Add Shortcode:
 * [lbmn_commentscount]
 *
 * Outputs comments count
 */
add_shortcode( 'lbmn_commentscount', 'lbmn_commentscount_shortcode' );
function lbmn_commentscount_shortcode() {
	$num_comments = get_comments_number(); // get_comments_number returns only a numeric value

	if ( $num_comments == 0 ) {
		$comments = __('No Comments', 'lbmn');
	} elseif ( $num_comments > 1 ) {
		$comments = $num_comments . __(' Comments', 'lbmn');
	} else {
		$comments = __('1 Comment', 'lbmn');
	}

	$output = $comments;

	return $output;
}


/**
 * Add Shortcode:
 * [lbmn_archive_heading]
 *
 * Outputs comments count
 */
add_shortcode( 'lbmn_archive_heading', 'lbmn_archive_heading_shortcode' );
function lbmn_archive_heading_shortcode() {

	$output = '';

		if ( DS_LIVE_COMPOSER_ACTIVE ) :
			$output .= __( 'This heading will be automatically generated by a theme' , 'lbmn' );

		elseif ( is_category() ) :
			$output .= sprintf( __( 'Category Archives: %s', 'lbmn' ), '<span>' . single_cat_title( '', false ) . '</span>' );

		elseif ( is_tag() ) :
			$output .= sprintf( __( 'Tag Archives: %s', 'lbmn' ), '<span>' . single_tag_title( '', false ) . '</span>' );

		elseif ( is_author() ) :
			/* Queue the first post, that way we know
			 * what author we're dealing with (if that is the case).
			*/
			the_post();
			$output .= sprintf( __( 'Author Archives: %s', 'lbmn' ), '<span class="vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '" title="' . esc_attr( get_the_author() ) . '" rel="me">' . get_the_author() . '</a></span>' );
			/* Since we called the_post() above, we need to
			 * rewind the loop back to the beginning that way
			 * we can run the loop properly, in full.
			 */
			rewind_posts();

		elseif ( is_day() ) :
			$output .= sprintf( __( 'Daily Archives: %s', 'lbmn' ), '<span>' . get_the_date() . '</span>' );

		elseif ( is_month() ) :
			$output .= sprintf( __( 'Monthly Archives: %s', 'lbmn' ), '<span>' . get_the_date( 'F Y' ) . '</span>' );

		elseif ( is_year() ) :
			$output .= sprintf( __( 'Yearly Archives: %s', 'lbmn' ), '<span>' . get_the_date( 'Y' ) . '</span>' );

		elseif ( is_tax( 'post_format', 'post-format-aside' ) ) :
			$output .= __( 'Asides', 'lbmn' );

		elseif ( is_tax( 'post_format', 'post-format-image' ) ) :
			$output .= __( 'Images', 'lbmn');

		elseif ( is_tax( 'post_format', 'post-format-video' ) ) :
			$output .= __( 'Videos', 'lbmn' );

		elseif ( is_tax( 'post_format', 'post-format-quote' ) ) :
			$output .= __( 'Quotes', 'lbmn' );

		elseif ( is_tax( 'post_format', 'post-format-link' ) ) :
			$output .= __( 'Links', 'lbmn' );

		elseif ( is_search() ) : // special title for search result page
			// get number of posts found for search query
			global $wp_query;
			$search_results_count = $wp_query->found_posts;

			$output .= __( 'You are searching for: ', 'lbmn' );
			$output .= '<strong>' . get_query_var('s') . '</strong>. <br />';

			if ( 1 == $search_results_count ) {
				$output .= __( 'There is one post that match your criteria...', 'lbmn' );
			} elseif ( 1 < $search_results_count ) {
				$output .= sprintf( __( 'Here are %s posts that match your criteria...', 'lbmn' ), '<span>' . $search_results_count . '</span>' );
			} else {
				$output .= __( 'Looks like nothing was found. Sorry.', 'lbmn' );
			}

		elseif ( is_front_page() ) :
			$output .= get_bloginfo( 'description' );

		else :
			$output .= __( 'Archives', 'lbmn' );

		endif;

	return $output;
}


