<?php

class ffThemeBuilderBlock_HTML extends ffThemeBuilderBlock {
/**********************************************************************************************************************/
/* OBJECTS
/**********************************************************************************************************************/

/**********************************************************************************************************************/
/* PRIVATE VARIABLES
/**********************************************************************************************************************/

/**********************************************************************************************************************/
/* CONSTRUCT
/**********************************************************************************************************************/
	protected function _init() {
		$this->_setInfo( ffThemeBuilderBlock::INFO_ID, 'html');
		$this->_setInfo( ffThemeBuilderBlock::INFO_WRAPPING_ID, 'html');
		$this->_setInfo( ffThemeBuilderBlock::INFO_WRAP_AUTOMATICALLY, true);
		$this->_setInfo( ffThemeBuilderBlock::INFO_IS_REFERENCE_SECTION, false);
		$this->_setInfo( ffThemeBuilderBlock::INFO_SAVE_ONLY_DIFFERENCE, true);
	}
/**********************************************************************************************************************/
/* PUBLIC FUNCTIONS
/**********************************************************************************************************************/

/**********************************************************************************************************************/
/* PUBLIC PROPERTIES
/**********************************************************************************************************************/

/**********************************************************************************************************************/
/* PRIVATE FUNCTIONS
/**********************************************************************************************************************/


	protected function _render( $query ) {
		if( $this->_queryIsEmpty() ) {
			return '';
		}

		echo htmlspecialchars_decode($query->get('html'));
	}

	protected function _injectOptions( ffThemeBuilderOptionsExtender $s ) {
		$s->addElement( ffOneElement::TYPE_HTML, '', 'HTML CONTENT');

		$s->addOption( ffOneOption::TYPE_TEXTAREA, 'html', 'HTML', '');
	}
/**********************************************************************************************************************/
/* PRIVATE GETTERS & SETTERS
/**********************************************************************************************************************/
}