<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.4.1/css/all.css" integrity="sha384-5sAR7xN1Nv6T6+dT2mhtzEpVJvfS3NScPQTrOxhwjIuvcA67KV2R5Jz6kr4abQsz" crossorigin="anonymous">
    <!-- Background images need to be 600px x 528px before you start -->
    <?php
        $background = array('background1.jpg', 'background2.jpg', 'background3.jpg', 'background4.jpg', 'background5.jpg', 'background6.jpg', 'background7.jpg', 'background8.jpg', 'background9.jpg', 'background10.jpg', 'background11.jpg', 'background12.jpg', 'background13.jpg', 'background14.jpg', 'background15.jpg', 'background16.jpg', 'background17.jpg', 'background18.jpg', 'background19.jpg', 'background20.jpg', 'background21.jpg', 'background22.jpg', 'background23.jpg', 'background24.jpg' );
        $i = rand(0, count($background)-1);
        $selectedBackground = "$background[$i]"; ?>
        <style type="text/css">
            @import url('https://fonts.googleapis.com/css?family=IBM+Plex+Sans:700');
            body html {
                height: 100%;
                position: relative;
            }
            
            .logo-container,
            .main {
                position: relative;
            }
            
            .logo-container img,
            .main {
                display: block;
            }
            
            body {
                margin: 0;
                font-family: 'IBM Plex Sans', sans-serif;
                font-size: 1em;
                color: #111;
            }
            
            footer {
                margin: 0em 0em 0em 0em;
            }
            
            .main {
                overflow: auto;
                top: 50%;
                margin-top: 0.5em;
            }
            
            .logo-container {
                pointer-events: none;
                background: url('http://cloudabove.com/backgrounds/<?php echo $selectedBackground;?>') no-repeat;
                background-size: cover;/* this makes the background image scale to fill the container */
                max-width: 498px;
                margin: 0 auto;
            }
            
            .text {
                text-align: center;
                font-size: 1em;
                line-height: 1.75em;
            }
            
            h1 {
                font-size: 2.5em;
                text-transform: uppercase;
                margin: 0.7em 0em 1em 0em;
            }
            
            h2 {
                font-size: 1.2em;
                text-transform: uppercase;
                margin: 1.5em 0em 0.1em 0em;
            }
            
            a {
                text-decoration: none;
            }
            
            p {
                margin: 0em auto;
                font-size: 0.95em;
                line-height: normal;
                text-transform: uppercase;
            }

            img {

            }
            
            .buttonBox {
                display: flex;
                flex-direction: row;
                flex-wrap: wrap;
                align-items: center;
                justify-content: center;
            }
            
            .button {
                width: 9em;
                border: none;
                text-align: center;
                padding: 1.2vw 3vw 1vw;
                border-radius: 0.2vw;
                text-transform: uppercase;
                margin: 1.3vw;
                outline: none;
                cursor: pointer;
                transition: all .15s;
                color: #000;
                background: #FFF;
                box-shadow: 0 .4vw 0 hsl(270, 2%, 8%);
            }
            
            .button:hover {
                background: #E6E9ED;
            }
            .button:focus {
                outline: none;
                box-shadow: #FFD503 0 0 0 2px;
            }
            
            .icon {
                font-size: 2em;
                margin: 0.35em;
                color: #000;
            }
            .social__container {
                display: inline-block;
            }
            
            .social {
                font-size: 1.85em;
                margin: 0em 0.1em 0 0.1em;
                color: #111;
            }
            
            /*
            Added a container class for the footer links. Google "BEM css" to learn more about the
            double-underscore in "social__container".
            */
            .social__container:focus {
                outline: none;
            }
            /* More a11y stuff, this time for the footer links */
            .social__container:focus .social{
                box-shadow: #FFD503 0 0 0 2px;
            }
            
            @media all and (max-width:1024px) {
                .logo-container {
                    max-width: 498px;
                }
            }
            
            @media all and (max-width:700px) {
                body {
                    font-size: 0.9em;
                }
                .logo-container {
                    max-width: 398px;
                }
                h1 {
                    font-size: 2em;
                }
                footer {
                    margin-top: 1em;
                }
            }
            
            @media all and (max-width:400px) {
                body {
                    /* This looks way too small for me - maybe experiment with less-tiny text on mobile? */
                    font-size: 1em;
                }
                .logo-container {
                    max-width: 298px;
                }
                h1 {
                    font-size: 1.8em;
                }
                .buttonBox {
                    flex-direction: column;
                }
                .button {
                    width: 50%;
                    height: 50%;
                    margin: 0 auto;
                }
            }
        </style>
</head>
<body>
    <div class="main">
        <div class="logo-container">
            <a target="_blank" href="https://cloudabove.com/"><img src="http://cloudabove.com/backgrounds/cloudabovev2.svg" alt="cloudabove" /></a>
        </div>
        <div class="text">
            <h1><script>document.write(location.hostname)</script></h1>
            <div class="buttonBox">
                <a class="button" target="_blank" href="/cpanel">
                    <p>Manage hosting</p>
                    <span class="fas fa-server icon"></span>
                </a>
                <a class="button" target="_blank" href="/webmail">
                    <p>Access emails</p>
                    <span class="fas fa-envelope-open icon"></span>
                </a>
                <a class="button" target="_blank" href="https://support.cloudabove.com">
                    <p>Support guides</p>
                    <span class="fas fa-archive icon"></span>
                </a>
            </div>
            <h2>Need assistance with your hosting?</h2>
            <div class="buttonBox">
                <a class="button" target="_blank" href="mailto:support@cloudabove.com">
                    <p>Send us an email</p>
                    <span class="fas fa-envelope icon"></span>
                </a>
                <a class="button" href="tel:01872672050">
                    <p>Give us a call</p>
                    <span class="fas fa-phone icon"></span>
                </a>
            </div>
            <footer>
                <a class="social__container" target="_blank" href="https://www.facebook.com/cloudaboveuk"><i class="fab fa-facebook-square social"></i></a>
                <a class="social__container" target="_blank" href="https://twitter.com/cloudabove"><i class="fab fa-twitter-square social"></i></a>
            </footer>
        </div>
    </div>
</body>
</html>