<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package fibremarketing
 */

get_header();
?>
<link rel="stylesheet" id="js_composer_front-css" href="https://fibre.marketing/wp-content/plugins/js_composer/assets/css/js_composer.min.css?ver=6.0.3" media="all">
	<main id="primary" class="site-main entry-content">

		<?php if ( have_posts() ) : ?>

			<header class="page-header">
				<h1 class="page-title">
					<?php
					/* translators: %s: search query. */
					printf( esc_html__( 'Search Results for: %s', 'fibremarketing' ), '<span>' . get_search_query() . '</span>' );
					?>
				</h1>
			</header><!-- .page-header -->
            <div class="vc_row wpb_row blog-content vc_row-fluid">
                <div class="wpb_column vc_column_container vc_col-sm-8">
                    <div class="vc_column-inner">
			<?php
			/* Start the Loop */
			while ( have_posts() ) :
				the_post();

				/**
				 * Run the loop for the search to output the results.
				 * If you want to overload this in a child theme then include a file
				 * called content-search.php and that will be used instead.
				 */
				get_template_part( 'template-parts/content', 'search' );

			endwhile;

		
		?>
		        </div>
		    </div>
		    <div class="wpb_column vc_column_container vc_col-sm-4">
		        <div class="vc_column-inner">
    		        <div class="BlogRightPanel">
                        <?php get_sidebar (); ?>
                    </div>
		       </div>
		    </div>
        </div>
        
	    <?php
		    else :
		        ?>
		        <header class="page-header">
		<h1 class="page-title"><?php esc_html_e( 'Nothing Found', 'fibremarketing' ); ?></h1>
	</header><!-- .page-header -->
	        <div class="vc_row wpb_row blog-content vc_row-fluid">
                <div class="wpb_column vc_column_container vc_col-sm-8">
                    <div class="vc_column-inner">

			<?php get_template_part( 'template-parts/content', 'none' );
			?>
</div>
		    </div>
		    <div class="wpb_column vc_column_container vc_col-sm-4">
		        <div class="vc_column-inner">
    		        <div class="BlogRightPanel">
                        <?php get_sidebar (); ?>
                    </div>
		       </div>
		    </div>
        </div>
		<?php endif;
		    ?>
	</main><!-- #main -->

<?php
the_posts_navigation();
get_footer();
