<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package fibremarketing
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">
	<link rel="preload" href="https://fibre.marketing/wp-content/themes/fibremarketing/flexo-bold.woff2" as="font" type="font/woff2" crossorigin="anonymous">
	<link rel="preload" href="https://fibre.marketing/wp-content/themes/fibremarketing/flexo-demi.woff2" as="font" type="font/woff2" crossorigin="anonymous">
	<link rel="preload" href="https://fibre.marketing/wp-content/themes/fibremarketing/flexo-regular.woff2" as="font" type="font/woff2" crossorigin="anonymous">
	<?php wp_head(); ?>
	
	<link rel="icon" href="/favicon.ico">
	<script type="text/javascript">jQuery(document).ready(function($){$(".whyChoose,div#org-search,div#con-marketing").wrapAll("<div class='topBg'></div>"),$("#seo-audit,#digitalpr").wrapAll("<div class='middleBg'></div>"),$("#web-migration,#rep-mgmt,.recentc").wrapAll("<div class='bottomBg'> </div>"),$(".fullServicesP,.aboutsec,.about_team").wrapAll("<div class='aboutBg'> </div>"),$(".RepoTopBg").wrapAll("<div class='RepowrapOut'><div class='RepowrapIn'> </div> </div>"),$(".page-id-758 .label-seo, .page-id-758 div#services").wrapAll("<div class='lablewrap'><div class='container'> </div> </div>"),$(".label-exp,.label-client,.page-id-758 .recentWorks").wrapAll("<div class='lableExpwrap'><div class='container'> </div> </div>"),$(".wrap1").wrapAll("<div class='wrap1wrap'> </div>"),$(".wrap2").wrapAll("<div class='wrap2wrap'> </div>"),$(".wrap3").wrapAll("<div class='wrap3wrap'> </div>"),$(".recentc").addClass("container")});</script>
</head>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<div id="page" class="site form-design-skin1">
	<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e( 'Skip to content', 'fibremarketing' ); ?></a>
    <?php $classes = get_body_class();
    if (in_array('case_studies-template-default',$classes)) {
        $extraclass = "Transparent";
    } ?>
	<header id="masthead" class="site-header <?= get_field('header_type')?> <?= $extraclass?>">
		<div class="site-branding">
			<?php
			if(get_field('header_type') != "Transparent" && $extraclass != "Transparent"){
			    ?>
			    <a href="https://fibre.marketing/" class="custom-logo-link" rel="home"><img alt="Fibre Marketing" data-src="https://fibre.marketing/wp-content/uploads/2020/09/colourfibrelogo.svg" class="custom-logo lazyloaded" src="https://fibre.marketing/wp-content/uploads/2020/09/colourfibrelogo.svg">
		            <img data-src="https://fibre.marketing/wp-content/uploads/2021/07/GLSA21-Winner-Badge1.png" class="custom-logo award" src="https://fibre.marketing/wp-content/uploads/2021/07/GLSA21-Winner-Badge1.png">
			    </a>
		        <?php
			} else {
			    ?>
			    <a href="<?=get_home_url()?>" class="custom-logo-link" rel="home">
			        <img alt="Fibre Marketing" data-src="https://fibre.marketing/wp-content/uploads/2020/09/whitfibrelogo.svg" class="custom-logo" src="https://fibre.marketing/wp-content/uploads/2020/09/whitfibrelogo.svg">
			        <img data-src="https://fibre.marketing/wp-content/uploads/2021/07/GLSA21-Winner-Badge2-1.png" class="custom-logo award" src="https://fibre.marketing/wp-content/uploads/2021/07/GLSA21-Winner-Badge2-1.png">
			    </a>
			    <?php
			}
			if ( is_front_page() && is_home() ) :
				?>
				<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
				<?php
			else :
				?>
				<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
				<?php
			endif;
			$fibremarketing_description = get_bloginfo( 'description', 'display' );
			if ( $fibremarketing_description || is_customize_preview() ) :
				?>
				<p class="site-description"><?php echo $fibremarketing_description; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></p>
			<?php endif; ?>
		</div><!-- .site-branding -->

		<nav id="site-navigation" class="main-navigation" [class]="visible ? ' main-navigation toggled' : 'main-navigation'"> 
			<button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false" on="tap:AMP.setState({visible: !visible})"  ><i class="icon-menuggticon-" ></i></button>
			<img src="https://fibre.marketing/wp-content/uploads/2020/09/colourfibrelogo.svg" class="show-mobile">
			<?php
			wp_nav_menu(
				array(
					'theme_location' => 'menu-1',
					'menu_id'        => 'primary-menu',
				)
			);
			?>
			<div id="menu"  [class]="visible ? 'show' : 'hide'" class="hide">
			<?php
			wp_nav_menu(
				array(
					'theme_location' => 'menu-1',
					'menu_id'        => 'primary-menu',
				)
			);
			?>
			</div>
		</nav><!-- #site-navigation -->
		
	</header><!-- #masthead -->
